import java.io.*;
import java.util.*;

class Document {
	private String title;
	private Vector body;
	
	public Document(String s) {
		title = s;
		body = new Vector();
	}
	
	public void add(String col1, String col2) {
		body.add(new Ligne(col1, col2));
	}
	
	public void output(PrintWriter pw) {
		pw.println(getContenu());
	}
	
	public String getContenu() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("<html><head><title>");
		buffer.append(title);
		buffer.append("</title></head>");
		buffer.append("<body bgcolor='white'><center>");
		buffer.append("<h2>");
		buffer.append(title);
		buffer.append("</h2>");
		buffer.append("<table cellspacing='0' cellpadding='0' border='0'"
					+ " width='300'>");
		Iterator it = body.iterator();
		while (it.hasNext()) {
			buffer.append(((Ligne)it.next()).getContenu());
		}
		buffer.append("</table></center></body></html>");
		return buffer.toString();
	}
}

class Ligne {
	private String col1;
	private String col2;
	
	public Ligne(String c1, String c2) {
		col1 = c1;
		col2 = c2;
	}

	public String getContenu() {
		return "<tr><td height='30'>" 
				+ col1 + "</td><td><b>" 
				+ col2 + "</b></td></tr>";
	}
}