<?xml version="1.0" encoding="ISO-8859-1"?> 
<xsl:transform 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fo="http://www.w3.org/1999/XSL/Format"
		version="1.0">
<xsl:output indent="yes" method="xml" encoding="ISO-8859-1"/>

<xsl:template match="document">

<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">

  <!-- Format de page -->
  <fo:layout-master-set>

    <!-- Format de la premire page -->
    <fo:simple-page-master page-master-name="first"
                  page-height="29.7cm" 
                  page-width="21cm"
                  margin-top="1cm" 
                  margin-bottom="2cm" 
                  margin-left="5cm" 
                  margin-right="5cm">
      <fo:region-before extent="3cm"/>
      <fo:region-body margin-top="3cm"/>
      <fo:region-after extent="1.5cm"/>
    </fo:simple-page-master>

    <!-- Format des pages suivantes -->
    <fo:simple-page-master page-master-name="rest"
                  height="29.7cm" 
                  width="21cm"
                  margin-top="1cm" 
                  margin-bottom="2cm" 
                  margin-left="5cm" 
                  margin-right="5cm">
      <fo:region-before extent="2.5cm"/>
      <fo:region-body margin-top="2.5cm"/>
      <fo:region-after extent="1.5cm"/>
    </fo:simple-page-master>

  </fo:layout-master-set>
  <!-- Fin: Format de page -->

  <!-- Mise en page du document -->
  <fo:page-sequence>

    <!-- Utilisation des formats de page -->
    <fo:sequence-specification>
      <fo:sequence-specifier-repeating page-master-first="first" 
                                       page-master-repeating="rest"/>
    </fo:sequence-specification>


    <fo:flow flow-name="xsl-body">

      <!-- Titre -->
      <fo:block font-size="18pt" 
            font-family="sans-serif" 
            line-height="24pt"
            space-after.optimum="15pt"
            background-color="blue"
            color="white"
            text-align="centered"
            padding-top="3pt">
			<xsl:value-of select=".//titre"/>            
      </fo:block>
      
      <!-- Tableau -->
      <fo:block font-size="12pt" 
            font-family="sans-serif" 
            line-height="24pt"
            space-after.optimum="15pt"
            background-color="yellow"
            color="blue"
            text-align="start"
            padding-top="3pt">
        <fo:table table-width="300pt">
          <fo:table-column column-width="150pt"></fo:table-column>
          <fo:table-column column-width="20pt"></fo:table-column>
          <fo:table-column column-width="130pt"></fo:table-column>
          <fo:table-body>
			<xsl:apply-templates/>
          </fo:table-body>
        </fo:table>
      </fo:block>

    </fo:flow>
  </fo:page-sequence>
</fo:root>

</xsl:template>

<xsl:template match="titre">
</xsl:template>

<xsl:template match="departement">
	<fo:table-row>
		<fo:table-cell text-align="end">
			<fo:block>
				Dpartement :
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block font-weight="bold">
				<xsl:apply-templates/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:template>

<xsl:template match="code">
	<fo:table-row>
		<fo:table-cell text-align="end">
			<fo:block>
				Code :
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block font-weight="bold">
				<xsl:apply-templates/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:template>

<xsl:template match="region">
	<fo:table-row>
		<fo:table-cell text-align="end">
			<fo:block>
				Rgion :
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block font-weight="bold">
				<xsl:apply-templates/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:template>

<xsl:template match="prefecture">
	<fo:table-row>
		<fo:table-cell text-align="end">
			<fo:block>
				Prfecture :
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block font-weight="bold">
				<xsl:apply-templates/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:template>

<xsl:template match="indicatif">
	<fo:table-row>
		<fo:table-cell text-align="end">
			<fo:block>
				Indicatif tlphonique :
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block font-weight="bold">
				<xsl:apply-templates/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:template>

</xsl:transform>