import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class BC1 extends HttpServlet {

	public void doPost(	HttpServletRequest requte,
						HttpServletResponse rponse)
						throws IOException, ServletException
	{
		boolean debug = true;
		rponse.setContentType("text/html");
		PrintWriter pw = rponse.getWriter();
		
		String dest = requte.getParameter("email");
		String expe = "ventes@volga.fr";
		String sujet = "Confirmation de commande";
		String message = "Nous avons bien reu votre commande, qui vous "
				+ "sera expdie ds rception de votre chque.";
				
		String serveur = "smtp.volga.fr";
		Socket socket = new Socket(serveur, 25);
		
		PrintWriter mailWriter 
					= new PrintWriter(socket.getOutputStream(), true);
		BufferedReader mailReader 
					= new BufferedReader(new InputStreamReader(
						socket.getInputStream()));
		StringBuffer buffer = new StringBuffer();
				
		connecter(mailWriter, mailReader, buffer);
		envoyerCommande("MAIL FROM:", expe, mailWriter, mailReader, buffer);
		envoyerCommande("RCPT TO:", dest, mailWriter, mailReader, buffer);
		envoyerCommande("DATA", "", mailWriter, mailReader, buffer);
		envoyerDonnes(dest, sujet, message, mailWriter, mailReader, buffer);
		fermer(socket, mailWriter, mailReader, buffer);

		pw.println("<html>");
		pw.println("<head>");
		pw.println("<title>Confirmation de commande</title>");
		pw.println("</head>");
		pw.println("<body>");
		if (debug)
		{
			pw.println(buffer.toString());
		}
		pw.println("<h3>Votre commande a t enregistre.</h3>");
		pw.println("</body>");
		pw.println("</html>");
	}
	
	private void connecter(
//					String serveur,
					PrintWriter mailWriter,
					BufferedReader mailReader,
					StringBuffer buffer)
					throws IOException
	{
		buffer.append("<p>" + mailReader.readLine());	
		buffer.append("HELO localhost\r\n");
		mailWriter.print("HELO localhost\r\n");
		mailWriter.flush();
		buffer.append("<br>" + mailReader.readLine());
	}
	
	private void envoyerCommande(
					String commande,
					String paramtre,
					PrintWriter mailWriter,
					BufferedReader mailReader,
					StringBuffer buffer)
					throws IOException
	{
		buffer.append("<br>" + commande + paramtre + "\n");
		if (!paramtre.equals(""))
		{
			paramtre = "<" + paramtre + ">";
		}
		mailWriter.print(commande + paramtre + "\r\n");
		mailWriter.flush();
		buffer.append("<br>" + mailReader.readLine());
	}

	private void envoyerDonnes(
					String dest,
					String sujet,
					String message,
					PrintWriter mailWriter,
					BufferedReader mailReader,
					StringBuffer buffer)
	{
		buffer.append("to: " + dest + "\r\n");
		mailWriter.print("to: " + dest + "\r\n");
		buffer.append("subject: " + sujet + "\r\n");
		mailWriter.print("subject: " + sujet + "\r\n");
		buffer.append(message + "\r\n");
		mailWriter.print(message + "\r\n");
	}
	
	private void fermer(
					Socket socket,
					PrintWriter mailWriter,
					BufferedReader mailReader,
					StringBuffer buffer)
					throws IOException
	{
		mailWriter.print("\r\n.\r\n");
		mailWriter.flush();
		buffer.append("<br>" + mailReader.readLine());
		buffer.append("<br>" + "QUIT" + "\n");
		mailWriter.print("QUIT" + "\r\n");
		mailWriter.flush();
		buffer.append("<br>" + mailReader.readLine());
		socket.close();
	}
}