import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class Mmind extends HttpServlet
{
	public void doPost(	HttpServletRequest requte,
						HttpServletResponse rponse)
						throws IOException, ServletException
	{
		rponse.setContentType("text/html");
		PrintWriter pw = rponse.getWriter();
		String[] chiffre1 = requte.getParameterValues("1");

		String[] chiffre2 = requte.getParameterValues("2");
		String[] chiffre3 = requte.getParameterValues("3");
		String[] chiffre4 = requte.getParameterValues("4");
		String[] blancs = null;
		String[] noirs = null;
		String[][] chiffres = {
								chiffre1, 
								chiffre2, 
								chiffre3, 
								chiffre4, 
								blancs, 
								noirs};
		boolean trouv = false;
	
		if (chiffre1 == null)
		{
			initChiffres(chiffres);
		}
		else
		{
			trouv = controleHypothse(chiffres);
		}
		
		initForm(pw, chiffres, trouv);
		afficheChiffres(pw, chiffres, trouv);
		afficheHypothse(pw, trouv);
		finForm(pw);
	}
	
	private void initChiffres(String[][] chiffres)
	{
		for (int i = 0; i < 4; i++)
		{
			chiffres[i] = new String[] 
						{"" + (int)Math.floor(Math.random() * 10)};
System.out.println(chiffres[i][0]);
		}
	}
	
	private void initForm(PrintWriter pw, String[][] chiffres, boolean trouv)
	{
		pw.println("<html>");
		pw.println("<body bgcolor='white'>");
		pw.println("<h1 align='center'>");
		if (trouv)
		{
			pw.println("Bravo !");
		}
		else
		{
			pw.println("Essai n ");
			pw.println(chiffres[0].length);
		}
		pw.println("</h1>");
		pw.println("<center>");
		pw.println("<form method='post' action='Mmind'>");
		pw.println("<font face='sans-serif' style='bold'>");
		pw.println("<table border='1' bgcolor='#DDDDDD'>");
	}

	private void finForm(PrintWriter pw)
	{
		pw.println("</table>");		
		pw.println("</form>");
		pw.println("</center>");
		pw.println("</body>");
		pw.println("</html>	");	
	}
	
	private void afficheChiffres(
						PrintWriter pw, 
						String[][] chiffres, 
						boolean trouv)
	{
		pw.print("<tr>");
		for (int chiffre = 0; chiffre < 4; chiffre++)
		{
			pw.print("<td align='center'><b>");
			if (trouv)
			{
				pw.print(chiffres[chiffre][0]);
			}
			else
			{
				pw.print("X");
				System.out.println(chiffres[chiffre][0]);
				pw.print("<input type='hidden' name='");
				pw.print(chiffre + 1);
				pw.print("' value='");
				pw.print(chiffres[chiffre][0]);
				pw.print("'>");
			}
		}
		pw.print("<td></td>");
		pw.print("<td bgcolor='white'><font color='white'>&nbsp;0&nbsp;</td>");
		pw.print("<td bgcolor='black'><font color='black'>&nbsp;0&nbsp;</td>");
		pw.println("</tr>");
		pw.println("<tr><td height='10'></td></tr>");
		for (int essai = 1; essai < chiffres[0].length; essai++)
		{
			pw.println("<tr>");
			for (int chiffre = 0; chiffre < 4; chiffre++)
			{
			  pw.print("<td align='center'><b>");
			  if (!trouv)
			  {
				  pw.print("<input type='hidden' name='");
				  pw.print(chiffre + 1);
				  pw.print("' value='");
				  pw.print(chiffres[chiffre][essai]);
				  pw.print("'>");
			  }
			  pw.print(chiffres[chiffre][essai]);
			  pw.print("</b></td>");
			}
			pw.print("<td></td>");
			pw.print("<td align='center' bgcolor='white'>");
			pw.print("<font color='black'><b>");
			pw.print(chiffres[4][essai]);
			pw.print("</font></td>");
			pw.print("<td align='center' bgcolor='black'>");
			pw.print("<font color='white'><b>");
			pw.print(chiffres[5][essai]);
			pw.print("</font></td>");
			pw.println("</tr>");
		}
	}
	
	private void afficheHypothse(PrintWriter pw, boolean trouv)
	{
		if (!trouv)
		{
			pw.println("<tr>");
			for (int chiffre = 0; chiffre < 4; chiffre++)
			{
				pw.print("<td>&nbsp;&nbsp;&nbsp;");
				pw.println("<select name='" +(chiffre + 1) + "'>");
				pw.println("<option>0");
				pw.println("<option>1");
				pw.println("<option>2");
				pw.println("<option>3");
				pw.println("<option>4");
				pw.println("<option>5");
				pw.println("<option>6");
				pw.println("<option>7");
				pw.println("<option>8");
				pw.println("<option>9");
				pw.println("</select>");
				pw.println("</td>");
			}
			pw.println("<td></td><td></td></tr>");
			pw.println("<tr>");
			pw.println("<td height='10'>");	
			pw.println("</td>");
			pw.println("</tr>");
		}
		pw.println("<tr>");
		pw.println("<td colspan='7'  align='center'>");
		pw.println("<input type='submit' value=");
		if (trouv)
		{
			pw.println("'           Nouvelle partie           '>");
		}
		else
		{
			pw.println("'                      Jouer                      '>");
		}
		pw.println("</td>");
		pw.println("</tr>");
	}
	
	private boolean controleHypothse(String[][] chiffres)
	{
		String[] blancs = new String[chiffres[0].length];
		String[] noirs = new String[chiffres[0].length];
		boolean[] utilis1 = new boolean[4];
		boolean[] utilis2 = new boolean[4];
		boolean trouv = false;
		for (int essai = 1; essai < chiffres[0].length; essai++)
		{
			for (int i = 0; i < 4; i++)
			{
				utilis1[i] = false;
				utilis2[i] = false;
			}
			int nbOk = 0;
			for (int chiffre = 0; chiffre < 4; chiffre++)
			{
				if (chiffres[chiffre][essai].equals(chiffres[chiffre][0]))
				{
					nbOk++;
					utilis1[chiffre] = true;
					utilis2[chiffre] = true;
				}
			}
			blancs[essai] = "" + nbOk;
			trouv = (nbOk == 4);
			nbOk = 0;
			for (int chiffre = 0; chiffre < 4; chiffre++)
			{
				for (int j = 0; j < 4; j++)
				{
					if (chiffres[chiffre][essai].equals(chiffres[j][0]) 
							&& !utilis1[j] && !utilis2[chiffre])
					{
						nbOk++;
						utilis1[j] = true;
						utilis2[chiffre] = true;
					}
				}
			}
			noirs[essai] = "" + nbOk;
		}
		chiffres[4] = blancs;
		chiffres[5] = noirs;
		
		return trouv;
	}
}