import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class MmindSessionJava extends HttpServlet
{
	public void doGet(	HttpServletRequest requte,
						HttpServletResponse rponse)
						throws IOException, ServletException
	{
		rponse.setContentType("text/html");
		PrintWriter pw = rponse.getWriter();
		boolean trouv = false;
		boolean perdu = false;
		HttpSession session = requte.getSession();
		String[] chiffre1 = null;
		String[] chiffre2 = null;
		String[] chiffre3 = null;
		String[] chiffre4 = null;
		String[] blancs = null;
		String[] noirs = null;
		String[][] chiffres = new String[6][23];
		String numEssai = "";		
		if (session.isNew())
		{
			chiffre1 = new String[23];
			chiffre2 = new String[23];
			chiffre3 = new String[23];
			chiffre4 = new String[23];
			blancs = new String[23];
			noirs = new String[23];
			chiffres[0] = chiffre1; 
			chiffres[1] = chiffre2; 
			chiffres[2] = chiffre3; 
			chiffres[3] = chiffre4; 
			chiffres[4] = blancs; 
			chiffres[5] = noirs; 
			initChiffres(chiffres);
			chiffre1[22] = "0"; // Numro de l'essai en cours

			session.setAttribute("chiffres", chiffres);
		}
		else
		{
			chiffres = (String[][])session.getAttribute("chiffres");
			if (chiffres == null)
			{
			   pw.print("<html>");
			   pw.print("<body bgcolor='white'>");
			   pw.print("<h1 align='center'>Cliquez pour jouer au ");
			   pw.print("MasterMind</h1>");
			   pw.print("<center>");
			   pw.print("<form method='get' action='http://localhost:8080/");
			   pw.print("servlet/" + getServletConfig().getServletName() 
			   			+ "'>");
			   pw.print("<input type='submit' value='Jouer'>");
			   pw.print("</form>");
			   pw.print("</center>");
			   pw.print("</body>");
			   pw.print("</html>");
			   return;
			}
			chiffre1 = chiffres[0];
			chiffre2 = chiffres[1];
			chiffre3 = chiffres[2];
			chiffre4 = chiffres[3];
			blancs = chiffres[4];
			noirs = chiffres[5];
			int nb = (new Integer(chiffre1[22])).intValue() + 1;
			if (nb > 20)
			{
				perdu = true;
			}
			chiffre1[22] = "" + nb;
			chiffre1[nb]= requte.getParameter("1");
			chiffre2[nb]= requte.getParameter("2");
			chiffre3[nb]= requte.getParameter("3");
			chiffre4[nb]= requte.getParameter("4");

			trouv = controleHypothse(chiffres);
		}
		
		if (trouv || perdu)
		{
			session.invalidate();
		}
		
		initForm(pw, chiffres, trouv, perdu);
		afficheChiffres(pw, chiffres, trouv, perdu);
		afficheHypothse(pw, trouv, perdu);
		finForm(pw);
	}
	
	private void initChiffres(String[][] chiffres)
	{
		for (int i = 0; i < 4; i++)
		{
			chiffres[i][0] = "" + (int)Math.floor(Math.random() * 10);
		}
	}
	
	private void initForm(
						PrintWriter pw, 
						String[][] chiffres, 
						boolean trouv,
						boolean perdu)
	{
		pw.println("<html><head><title>Mmind</title></head>");
		pw.println("<body bgcolor='white'>");
		pw.println("<h1 align='center'>");
		if (trouv)
		{
			pw.println("Bravo !");
		}
		else
		{
			if (perdu)
			{
				pw.println("Perdu !");
			}
			else
			{
				pw.println("Essai n ");
				pw.println((new Integer(chiffres[0][22])).intValue() + 1);
			}
		}
		pw.println("</h1>");
		pw.println("<center>");
		pw.print("<form method='get' action='http://localhost:8080");
		pw.print("/servlet/" + getServletConfig().getServletName());
		pw.print("'>");
		pw.println("<font face='sans-serif' style='bold'>");
		pw.println("<table border='1' bgcolor='#DDDDDD'>");
	}

	private void finForm(PrintWriter pw)
	{
		pw.println("</table>");		
		pw.println("</form>");
		pw.println("</center>");
		pw.println("</body>");
		pw.println("</html>	");	
	}
	
	private void afficheChiffres(
						PrintWriter pw,
						String[][] chiffres, 
						boolean trouv,
						boolean perdu)
	{
		pw.println("<tr>");
		for (int chiffre = 0; chiffre < 4; chiffre++)
		{
			pw.println("<td align='center'><b>");
			if (trouv || perdu)
			{
				pw.println(chiffres[chiffre][0]);
			}
			else
			{
				pw.println("X");
			}
		}
		pw.println("<td></td>");
		pw.println("<td bgcolor='white'>");
		pw.println("<font color='white'>&nbsp;0&nbsp;</td>");
		pw.println("<td bgcolor='black'>");
		pw.println("<font color='black'>&nbsp;0&nbsp;</td>");
		pw.println("</tr>");
		pw.println("<tr><td height='10'></td></tr>");
		for (	int essai = 1; 
				essai <= (new Integer(chiffres[0][22])).intValue(); 
				essai++)
		{
			pw.println("<tr>");
			for (int chiffre = 0; chiffre < 4; chiffre++)
			{
				pw.println("<td align='center'><b>");
				pw.println(chiffres[chiffre][essai]);
				pw.println("</b></td>");
			}
			pw.println("<td></td>");
			pw.println("<td align='center' bgcolor='white'>");
			pw.println("<font color='black'><b>");
			pw.println(chiffres[4][essai]);
			pw.println("</font></td>");
			pw.println("<td align='center' bgcolor='black'>");
			pw.println("<font color='white'><b>");
			pw.println(chiffres[5][essai]);
			pw.println("</font></td>");
			pw.println("</tr>");
		}
	}
	
	private void afficheHypothse(PrintWriter pw, boolean trouv, boolean perdu)
	{
		if (!trouv && !perdu)
		{
			pw.println("<tr>");
			for (int chiffre = 0; chiffre < 4; chiffre++)
			{
				pw.println("<td>&nbsp;&nbsp;&nbsp;");
				pw.println("<select name='" +(chiffre + 1) + "'>");
				pw.println("<option>0");
				pw.println("<option>1");
				pw.println("<option>2");
				pw.println("<option>3");
				pw.println("<option>4");
				pw.println("<option>5");
				pw.println("<option>6");
				pw.println("<option>7");
				pw.println("<option>8");
				pw.println("<option>9");
				pw.println("</select>");
				pw.println("</td>");
			}
			pw.println("<td></td><td></td></tr>");
			pw.println("<tr>");
			pw.println("<td height='10'>");	
			pw.println("</td>");
			pw.println("</tr>");
		}
		pw.println("<tr>");
		pw.println("<td colspan='7'  align='center'>");
		pw.println("<input type='submit' value=");
		if (trouv && perdu)
		{
			pw.println("'           Nouvelle partie           '>");
		}
		else
		{
			pw.println("'                      Jouer                      '>");
		}
		pw.println("</td>");
		pw.println("</tr>");
	}
	
	private boolean controleHypothse(String[][] chiffres)
	{
		String[] blancs = chiffres[4];
		String[] noirs = chiffres[5];
		boolean[] utilis1 = new boolean[4];
		boolean[] utilis2 = new boolean[4];
		boolean trouv = false;
		for (	int essai = 1; 
				essai <= (new Integer(chiffres[0][22])).intValue(); 
				essai++)
		{
			for (int i = 0; i < 4; i++)
			{
				utilis1[i] = false;
				utilis2[i] = false;
			}
			int nbOk = 0;
			for (int chiffre = 0; chiffre < 4; chiffre++)
			{
				if (chiffres[chiffre][essai].equals(chiffres[chiffre][0]))
				{
					nbOk++;
					utilis1[chiffre] = true;
					utilis2[chiffre] = true;
				}
			}
			blancs[essai] = "" + nbOk;
			trouv = (nbOk == 4);
			nbOk = 0;
			for (int chiffre = 0; chiffre < 4; chiffre++)
			{
				for (int j = 0; j < 4; j++)
				{
					if (chiffres[chiffre][essai].equals(chiffres[j][0]) 
							&& !utilis1[j] && !utilis2[chiffre])
					{
						nbOk++;
						utilis1[j] = true;
						utilis2[chiffre] = true;
					}
				}
			}
			noirs[essai] = "" + nbOk;
		}
		chiffres[4] = blancs;
		chiffres[5] = noirs;
		
		return trouv;
	}
}