import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.xalan.xslt.*;

public class DeptMenu extends HttpServlet {
	
	public void doGet(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
							
		String typeMIME = "text/html";
		String styleSheet = "DeptListe.xsl";
	
		reponse.setContentType(typeMIME);
		PrintWriter pw = reponse.getWriter();
		String[] result = getSQL("select Departement from regions");
		if (result == null)
		{
			// traitement d'erreur
			return;
		}
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version='1.0'?>");
		buf.append("<document>");
		for (int i = 0; i < result.length; i++)
		{
			buf.append("<departement>" + result[i] + "</departement>");
		}
		buf.append("</document>");
		
		xslTransform(buf.toString(), pw, styleSheet);
	}
	
	private void xslTransform(String buffer, Writer pw, String styleSheet) {
		
		try {
			// Instanciation d'un XSLProcessor  l'aide de XSLTProcessorFactory
			XSLTProcessor processor = XSLTProcessorFactory.getProcessor();

			// 
			XSLTInputSource xmlSource 
					= new XSLTInputSource(new StringReader(buffer));
			XSLTInputSource xslSheet 
					= new XSLTInputSource(getServletConfig()
					.getServletContext()
					.getRealPath("/" + styleSheet));
			XSLTResultTarget xmlResult 
					= new XSLTResultTarget(pw);

			// Transformation XSL
			processor.process(xmlSource, xslSheet, xmlResult);
		}
		catch(org.xml.sax.SAXException se) {
			System.out.println(se);
		}
	}
	
	private String[] getSQL(String command)
	{
		String[] result = null;
		
		// Chargement du driver JDBC
		try
		{
			Class.forName("org.gjt.mm.mysql.Driver").newInstance();
		}
		catch (Exception e)
		{
			System.err.println("Chargement du pilote impossible.");
			System.err.println(e);
		}
		
		// Etablissement de la connexion
		try
		{
			java.sql.Connection connexion 
				= java.sql.DriverManager.getConnection(
				"jdbc:mysql://localhost/base1?user=client&password=xd45ui");
			
			java.sql.Statement commande = connexion.createStatement();
			java.sql.ResultSet RS = commande.executeQuery(command);
			
			if (RS.last())
			{
				result = new String[RS.getRow()];
				RS.beforeFirst();
			}
			int i = 0;
			while (RS.next())
			{
				result[i++] = RS.getString(1);
			}
			RS.close();
			commande.close();
			connexion.close();
		}
		catch(java.sql.SQLException e)
		{
			System.err.println("***** SQLException : *****");
			while (e != null)
			{
				System.out.println("Message :     " + e.getMessage ());
				System.out.println("Etat :        " + e.getSQLState ());
				System.out.println("Code Erreur : " + e.getErrorCode () + "\n");
				e = e.getNextException();
			}
		}
		return result;
	}
}