import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.xalan.xslt.*;
import org.apache.fop.apps.*;
import org.apache.fop.render.pdf.*;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class DeptMulti2 extends HttpServlet {
	
	public void doGet(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException
	{
		doPost(requete, reponse);
	}
							
	public void doPost(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException
	{
							
		String styleSheet = null;
		String typeMIME = null;
		String dept = requete.getParameter("dept");
		String format = requete.getParameter("format");
		if (format == null)
		{
			format = "HTML";
		}
		boolean html = (format.equals("HTML"));
		boolean xml = (format.equals("XML"));
		boolean rtf = (format.equals("RTF"));
		boolean pdf = (format.equals("PDF"));
		boolean texte = (format.equals("Texte avec sparateurs"));
	
		PrintWriter pw = reponse.getWriter();
		String[] result = getResult(dept);
		
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version='1.0'?>");
		buf.append("<document>");
		buf.append("<titre>Les Dpartements Franais</titre>");
		buf.append("<departement>" + result[0] + "</departement>");
		buf.append("<code>" + result[1] + "</code>");
		buf.append("<region>" + result[2] + "</region>");
		buf.append("<prefecture>" + result[3] + "</prefecture>");
		buf.append("</document>");

		if (html)
		{
			styleSheet = "depthtml.xsl";
			typeMIME   = "text/html";
		}
		if (xml)
		{
			styleSheet = "deptxml.xsl";
			typeMIME   = "text/xml";
		}
		if (rtf)
		{
			styleSheet = "deptrtf.xsl";
			typeMIME   = "text/rtf";
		}
		if (pdf)
		{
			styleSheet = "deptfo.xsl";
			typeMIME   = "application/pdf";
		}
		if (texte)
		{
			styleSheet = "depttexte.xsl";
			typeMIME   = "text/plain";
		}
		
		reponse.setContentType(typeMIME);

		StringBuffer outBuf = new StringBuffer();
		StringWriter outWriter = new StringWriter();

		xslTransform(buf.toString(), outWriter, styleSheet);
		outBuf = outWriter.getBuffer();
		
		if (pdf)
		{
			xslfoRender(pw, outBuf.toString());
		}
		else
		{
			pw.println(outBuf.toString());
		}
	}
	
	private void xslfoRender(Writer pw, String styleSheet)
	{
		InputSource inputSource = new InputSource(new StringReader(styleSheet));
		Parser parser = new org.apache.xerces.parsers.SAXParser();

		Driver driver = new Driver();
		driver.setRenderer("org.apache.fop.render.pdf.PDFRenderer", "Volga");
		driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
		driver.setWriter((PrintWriter)pw);
		try
		{
			driver.buildFOTree(parser, inputSource);
			driver.format();
			driver.render();
		}
		catch (FOPException FOPe)
		{
			System.out.println(FOPe);
		}
		catch (IOException FOPe)
		{
			System.out.println(FOPe);
		}
	}

	private void xslTransform(String buffer, Writer pw, String styleSheet)
	{
		try
		{
			// Instanciation d'un XSLProcessor  l'aide de XSLTProcessorFactory
			XSLTProcessor processor = XSLTProcessorFactory.getProcessor();

			// 
			XSLTInputSource xmlSource 
					= new XSLTInputSource(new StringReader(buffer));
			XSLTInputSource xslSheet 
					= new XSLTInputSource(getServletConfig()
					.getServletContext()
					.getRealPath("/" + styleSheet));
			XSLTResultTarget xmlResult 
					= new XSLTResultTarget(pw);

			// Transformation XSL
			processor.process(xmlSource, xslSheet, xmlResult);
		}
		catch(org.xml.sax.SAXException se)
		{
			System.out.println(se);
		}
	}
	
	private String[] getResult(String s)
	{
		String dept = normalise(s);
		String[] result = new String[4];
		
		// Chargement du driver JDBC
		try
		{
			Class.forName("org.gjt.mm.mysql.Driver").newInstance();
		}
		catch (Exception e)
		{
			System.err.println("Chargement du pilote impossible.");
			System.err.println(e);
		}
		
		// Etablissement de la connexion
		try
		{
			java.sql.Connection connexion 
				= java.sql.DriverManager.getConnection(
				"jdbc:mysql://localhost/base1?user=client&password=xd45ui");
			
			java.sql.Statement commande = connexion.createStatement();
			java.sql.ResultSet RS = commande.executeQuery(
				"SELECT * from regions where (Departement='" + dept + "')");
			
			RS.next();
			result[0] = RS.getString(2);
			result[1] = RS.getString(1);
			result[2] = RS.getString(4);
			result[3] = RS.getString(3);

			RS.close();
			commande.close();
			connexion.close();
		}
		catch(java.sql.SQLException e)
		{
			System.err.println("***** SQLException : *****");
			while (e != null)
			{
				System.out.println("Message :     " + e.getMessage ());
				System.out.println("Etat :        " + e.getSQLState ());
				System.out.println("Code Erreur : " + e.getErrorCode () + "\n");
				e = e.getNextException();
			}
		}
		return result;
	}

	
	private String normalise(String chane) {
		
		StringBuffer buffer = new StringBuffer(chane.length());
		boolean espace = true;
		char car = ' ';
		for (int index1 = 0; index1 < chane.length(); index1++) {
			car = chane.charAt(index1);
			if (car == ' ') {
				if (espace)
					continue;
				espace = true;
				buffer.append('-');
			}
			else {
				if (car == '\'') {
					if (espace) {
						buffer.deleteCharAt(buffer.length() - 1);
					}
					espace = true;
				}
				else {
					espace = false;
				}
				buffer.append(car);
			}
		}
		if (espace) {
			buffer.deleteCharAt(buffer.length() - 1);
		}
		return buffer.toString();
	}
}