import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.xalan.xslt.*;

public class DeptServlet2 extends HttpServlet {
	
	public void doGet(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
							
		String styleSheet = requete.getParameter("stylesheet");
		if (styleSheet == null)
		{
			styleSheet = "depthtml2.xsl";
		}
		String typeMIME   = requete.getParameter("mime");
		if (typeMIME == null)
		{
			typeMIME = "text/html";
		}
		String dept = requete.getParameter("dept");
		
		reponse.setContentType(typeMIME);
		PrintWriter pw = reponse.getWriter();
		String[] result = getResult(dept);
		
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version='1.0'?>");
		buf.append("<document>");
		buf.append("<titre>Les Dpartements Franais</titre>");
		buf.append("<departement>" + result[0] + "</departement>");
		buf.append("<code>" + result[1] + "</code>");
		buf.append("<region>" + result[2] + "</region>");
		buf.append("<prefecture>" + result[3] + "</prefecture>");
//		buf.append("<indicatif>" + result[4] + "</indicatif>");
		buf.append("</document>");

		xslTransform(buf.toString(), pw, styleSheet);
	}
	
	private void xslTransform(String buffer, Writer pw, String styleSheet) {
		
		try {
			// Instanciation d'un XSLProcessor  l'aide de XSLTProcessorFactory
			XSLTProcessor processor = XSLTProcessorFactory.getProcessor();

			// 
			XSLTInputSource xmlSource 
					= new XSLTInputSource(new StringReader(buffer));
			XSLTInputSource xslSheet 
					= new XSLTInputSource(getServletConfig()
					.getServletContext()
					.getRealPath("/" + styleSheet));
			XSLTResultTarget xmlResult 
					= new XSLTResultTarget(pw);

			// Transformation XSL
			processor.process(xmlSource, xslSheet, xmlResult);
		}
		catch(org.xml.sax.SAXException se) {
			System.out.println(se);
		}
	}
	
	private String[] getResult(String s)
	{
		String dept = s;
		String[] result = new String[4];
		
		// Chargement du driver JDBC
		try
		{
			Class.forName("org.gjt.mm.mysql.Driver").newInstance();
		}
		catch (Exception e)
		{
			System.err.println("Chargement du pilote impossible.");
			System.err.println(e);
		}
		
		// Etablissement de la connexion
		try
		{
			java.sql.Connection connexion 
				= java.sql.DriverManager.getConnection(
				"jdbc:mysql://localhost/base1?user=client&password=xd45ui");
			
			java.sql.Statement commande = connexion.createStatement();
			java.sql.ResultSet RS = commande.executeQuery(
				"SELECT * from regions where (Departement='" + dept + "')");
			
			RS.next();
			result[0] = RS.getString(2);
			result[1] = RS.getString(1);
			result[2] = RS.getString(4);
			result[3] = RS.getString(3);

			RS.close();
			commande.close();
			connexion.close();
		}
		catch(java.sql.SQLException e)
		{
			System.err.println("***** SQLException : *****");
			while (e != null)
			{
				System.out.println("Message :     " + e.getMessage ());
				System.out.println("Etat :        " + e.getSQLState ());
				System.out.println("Code Erreur : " + e.getErrorCode () + "\n");
				e = e.getNextException();
			}
		}
		return result;
	}
}