package com.wrox.webshop.ejb.cart;

import java.rmi.*;
import java.util.*;

import javax.ejb.*;
import javax.naming.*;

import com.wrox.webshop.ejb.product.*;
import com.wrox.webshop.ejb.customer.*;

public class CartBean implements SessionBean
{
	private SessionContext	context;
	private HashMap			items;
	private Customer		customer;
	
	public static final long serialVersionUID = 120123;
	
	public void addProduct(String isbn)
	{
		if (isbn != null && !(isbn.equals("null")))
		{
			Integer count = (Integer) items.get(isbn);
			if (count == null) count = new Integer(0);
			items.put(isbn, new Integer(count.intValue()+1));
		}
	}	
	
	public void updateProduct(String isbn, int count)
	{
		if (isbn != null)
		{
			if (count==0)
			{
				items.remove(isbn);
			}
			else
			{
				items.put(isbn, new Integer(count));
			}		
		}
	}
	
	public HashMap getProducts()
	{		
		return items;
	}
	
	public int getTotalCost() throws RemoteException, CartException
	{
		int totalCost = 0;
		Iterator iterator = items.keySet().iterator();
		
		try
		{
			InitialContext context = new InitialContext();
			ProductHome productHome = (ProductHome) javax.rmi.PortableRemoteObject.narrow(context.lookup("Product"), ProductHome.class);
		
			while (iterator.hasNext())
			{
				try
				{
					String productID = (String) iterator.next();
					Product product = productHome.findByPrimaryKey(productID);
					totalCost += product.getPrice() * ((Integer) items.get(productID)).intValue();
				}
				catch (FinderException e)
				{
					throw new CartException(e.getMessage());
				}
			}
		}
		catch (NamingException e)
		{
			throw new CartException(e.getMessage());
		}
		
		return totalCost;
	}	
	
	public void login(String username, String password) throws LoginException, RemoteException
	{		
		try
		{
			InitialContext context = new InitialContext();
			CustomerHome customerHome = (CustomerHome) javax.rmi.PortableRemoteObject.narrow(context.lookup("Customer"), CustomerHome.class);
		
			Customer customer = customerHome.findByPrimaryKey(username);
			if (customer.authenticate(password))
			{
				this.customer = customer;
			}
			else
			{
				throw new LoginException();
			}
		}
		catch (FinderException e)
		{
			throw new LoginException();
		}		
		catch (NamingException e)
		{
			throw new LoginException();
		}		
	}
	
	public void logout()
	{
		customer = null;
	}
	
	public Customer getCustomer()
	{
		return customer;
	}
	
	public void ejbPassivate()
	{
	}

	public void ejbActivate()
	{
	}

	public void setSessionContext(SessionContext context)
	{
		this.context = context;
	}
	
	public void ejbRemove()
	{
		items = null;
	}

	public void ejbCreate()
	{
		items = new HashMap();
	}	
}
