package com.wrox.webshop.ejb.usermanager;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import java.util.*;

public class UserManagerBean implements SessionBean, SessionSynchronization
{
	private SessionContext	_context;
	private HashMap			_items;
	
	public void addProduct(String isbn)
	{
		System.out.println("add product1: "+isbn);
		if (isbn != null && !(isbn.equals("null")))
		{
			System.out.println("add product2: "+isbn);
			Integer count = (Integer) _items.get(isbn);
			if (count == null) count = new Integer(0);
			_items.put(isbn, new Integer(count.intValue()+1));
		}
	}	
	
	public void updateProduct(String isbn, int count)
	{
		System.out.println("update product: "+isbn);
		if (isbn != null)
		{
			if (count==0)
			{
				_items.remove(isbn);
			}
			else
			{
				_items.put(isbn, new Integer(count));
			}		
		}
	}
	
	public HashMap getProducts()
	{		
		return _items;
	}
	
	public int getTotalCost() throws RemoteException
	{
		int totalCost = 0;
		Iterator iterator = _items.keySet().iterator();
		
		try
		{
			InitialContext context = new InitialContext();
			ProductHome productHome = (ProductHome) javax.rmi.PortableRemoteObject.narrow(context.lookup("Product"), ProductHome.class);
		
			while (iterator.hasNext())
			{
				try
				{
					String productID = (String) iterator.next();
					Product product = productHome.findByPrimaryKey(productID);
					System.out.println("product found: "+product);
					totalCost += product.getPrice() * ((Integer) _items.get(productID)).intValue();
					System.out.println("total cost: "+totalCost);
				}
				catch (Exception e)
				{
					System.out.println("Error gTC: "+e.getMessage());
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		
		return totalCost;
	}	
	
	// ----------------------------------------------------
	// --- SessionSynchronization implementation ----------
	// ----------------------------------------------------

	public void afterBegin()
	{
		System.out.println("CartBean.afterBegin()");
	}

	public void beforeCompletion()
	{
		System.out.println("CartBean.beforeCompletion()");
	}

	public void afterCompletion(boolean success)
	{
		System.out.println("CartBean.afterCompletion(" + success + ")");
	}

	public void ejbPassivate()
	{
		System.out.println("CartBean.ejbPassivate()");
	}

	public void ejbActivate()
	{
		System.out.println("CartBean.ejbActivate()");
	}

	public void setSessionContext(SessionContext context)
	{
		System.out.println("CartBean.setSessionContext()");
		_context = context;
	}
	
	public void ejbRemove()
	{
		System.out.println("CartBean.ejbRemove()");		
		_items = null;
	}

	public void ejbCreate()
	{
		System.out.println("CartBean.ejbCreate()");	
		_items = new HashMap();
	}	
}
