package com.wrox.webshop.tags;

import java.rmi.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

import com.wrox.webshop.ejb.customer.*;
import com.wrox.webshop.ejb.cart.*;

public class GetUserTag extends TagSupport
{   
	/** 
	 * Method called at start of Tag
	 * @return either a EVAL_BODY_INCLUDE or a SKIP_BODY
	 */
	public int doStartTag() throws javax.servlet.jsp.JspException 
	{
		// if no cart is available or noone is logged in, don't evaluate the body
		int returnCode = SKIP_BODY;

		// get cart.
		Cart cart = (Cart) pageContext.getSession().getAttribute("cart");

		if (cart != null)
		{
			try
			{
				Customer customer = cart.getCustomer();
				if (customer != null)
				{
					pageContext.setAttribute(getId(), customer);
					returnCode = EVAL_BODY_INCLUDE;		
				}
			}
			catch (RemoteException e)
			{
				throw new JspException(e.getMessage());
			}
		}
		
		return returnCode;
	}
}
