package com.wrox.webshop.tags;

import java.util.*;
import java.io.*;
import java.rmi.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.naming.*;
import javax.ejb.*;

import com.wrox.webshop.ejb.customer.*;
import com.wrox.webshop.ejb.cart.*;
import com.wrox.webshop.ejb.product.*;

public class IterateTag extends BodyTagSupport
{   
	private String product;
	private int count;
	private Iterator iterator;
	private Context context;
	private String countid;
	private Cart cart;

	
	public void setCountid(String countid)
	{
		this.countid = countid;
	}

	public String getCountid()
	{
		return countid;
	}
	
	/** 
	 * Method called at start of Tag
	 * @return either a EVAL_BODY or a SKIP_BODY
	 */
	public int doStartTag() throws JspException 
	{		
		try
		{
			context = new InitialContext();
		}
		catch (NamingException e)
		{
			throw new JspException(e.getMessage());
		}
		
		// get cart.
		cart = (Cart) pageContext.getSession().getAttribute("cart");

		if (cart == null)
		{					
			try
			{
				CartHome cartHome = (CartHome)context.lookup("Cart");
				cart = cartHome.create();			
				pageContext.getSession().setAttribute("cart", cart);
			}
			catch (NamingException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (CreateException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (RemoteException e)
			{
				throw new JspException(e.getMessage());
			}
		}
		
		try
		{			
			iterator = ((HashMap) cart.getProducts()).keySet().iterator();
		}
		catch (java.rmi.RemoteException e)
		{
			e.printStackTrace();
		}
						
		if (iterator == null || !iterator.hasNext())
		{
			return SKIP_BODY;
		}
		else
		{
			try
			{
				ProductHome ph = (ProductHome) context.lookup("java:comp/env/ejb/product");
				Product p = ph.findByPrimaryKey((String)iterator.next());
			
				Integer count = (Integer) (cart.getProducts().get(p.getID()));
				
				pageContext.setAttribute(getId(), p, PageContext.PAGE_SCOPE);
				pageContext.setAttribute(getCountid(), count, PageContext.PAGE_SCOPE);				return EVAL_BODY_TAG;			
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return EVAL_BODY_TAG;
	}
	
	public int doAfterBody() throws JspException
	{
		if (iterator.hasNext())
		{
			try
			{
				ProductHome ph = (ProductHome) context.lookup("java:comp/env/ejb/product");
				Product p = ph.findByPrimaryKey((String) iterator.next());

				Integer count = (Integer) (cart.getProducts().get(p.getID()));
				
				pageContext.setAttribute(getId(), p, PageContext.PAGE_SCOPE);
				pageContext.setAttribute(getCountid(), count, PageContext.PAGE_SCOPE);
				return EVAL_BODY_TAG;			
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}				
		}
		return SKIP_BODY;
	}
	
	public int doEndTag() throws JspException
	{
		try
		{
			if(bodyContent != null)
			{
				bodyContent.writeOut(bodyContent.getEnclosingWriter());				
			}
		}
		catch (IOException e)
		{
			throw new JspException(e.getMessage());
		}
		return EVAL_PAGE;
	}
}
