package com.wrox.webshop.tags;

import java.rmi.*;
import java.io.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

import javax.naming.*;
import javax.ejb.*;

import com.wrox.webshop.ejb.cart.*;
import com.wrox.webshop.ejb.customer.*;

public class LoginTag extends TagSupport
{
	/** 
	 * Method called at start of Tag
	 * @return either a EVAL_BODY or a SKIP_BODY
	 */
	public int doStartTag() throws JspException 
	{
		// get cart.
		Cart cart = (Cart) pageContext.getSession().getAttribute("cart");

		if (cart == null)
		{					
			try
			{
				Context context = new InitialContext();
				CartHome cartHome = (CartHome)context.lookup("Cart");
				cart = cartHome.create();			
				pageContext.getSession().setAttribute("cart", cart);
			}
			catch (NamingException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (CreateException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (RemoteException e)
			{
				throw new JspException(e.getMessage());
			}
		}

		String username = pageContext.getRequest().getParameter("Name");
		String password = pageContext.getRequest().getParameter("Password");
		
		if (username != null && password != null)
		{
			try
			{
				cart.login(username, password);
			}
			catch (LoginException e)
			{
				try
				{
					pageContext.getOut().println("Incorrect Login, please try again");
				}
				catch (IOException e2)
				{
					throw new JspException(e2.getMessage());
				}				
			}
			catch (RemoteException e)
			{
				throw new JspException(e.getMessage());
			}
		}
		return SKIP_BODY;
	}
}
