package com.wrox.webshop.tags;

import java.rmi.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

import javax.naming.*;
import javax.ejb.*;

import com.wrox.webshop.ejb.cart.*;

public class LogoutTag extends TagSupport
{
	/** 
	 * Method called at start of Tag
	 * @return either a EVAL_BODY or a SKIP_BODY
	 */
	public int doStartTag() throws javax.servlet.jsp.JspException 
	{
		// get cart.
		Cart cart = (Cart) pageContext.getSession().getAttribute("cart");

		if (cart == null)
		{					
			try
			{
				Context context = new InitialContext();
				CartHome cartHome = (CartHome)context.lookup("Cart");
				cart = cartHome.create();			
				pageContext.getSession().setAttribute("cart", cart);
			}
			catch (NamingException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (CreateException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (RemoteException e)
			{
				throw new JspException(e.getMessage());
			}
		}

		try
		{
			cart.logout();
		}
		catch (RemoteException e)
		{
			throw new JspException(e.getMessage());
		}
		
		return SKIP_BODY;
	}
}
