package com.wrox.webshop.tags;

import java.rmi.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

import javax.naming.*;
import javax.ejb.*;

import com.wrox.webshop.ejb.cart.*;
import com.wrox.webshop.ejb.customer.*;

public class NoUserTag extends BodyTagSupport
{   
	/** 
	 * Method called at start of Tag
	 * @return either a EVAL_BODY or a SKIP_BODY
	 */
	public int doStartTag() throws javax.servlet.jsp.JspException 
	{
		// get cart.
		Cart cart = (Cart) pageContext.getSession().getAttribute("cart");

		if (cart == null)
		{					
			try
			{
				Context context = new InitialContext();
				CartHome cartHome = (CartHome)context.lookup("Cart");
				cart = cartHome.create();			
				pageContext.getSession().setAttribute("cart", cart);
			}
			catch (NamingException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (CreateException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (RemoteException e)
			{
				throw new JspException(e.getMessage());
			}
		}

		try
		{
			Customer customer = cart.getCustomer();
			if (customer == null)
			{
				return EVAL_BODY_TAG;
			}
			else
			{
				return SKIP_BODY;
			}
		}
		catch (RemoteException e)
		{
			throw new JspException(e.getMessage());
		}
	}    

	public int doEndTag() throws JspException
	{
		try
		{
			if(bodyContent != null)
			{
				bodyContent.writeOut(bodyContent.getEnclosingWriter());				
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return EVAL_PAGE;
	}

}
