package com.wrox.webshop.tags;

import java.io.*;
import java.rmi.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

import javax.naming.*;
import javax.ejb.*;

import com.wrox.webshop.ejb.cart.*;

public class UpdateProductTag extends TagSupport
{
	private String product;
	
	public void setProduct(String product)
	{
		this.product = product;
	}
	
	/** 
	 * Method called at start of Tag
	 * @return either a EVAL_BODY or a SKIP_BODY
	 */
	public int doStartTag() throws javax.servlet.jsp.JspException 
	{
		// get cart.
		Cart cart = (Cart) pageContext.getSession().getAttribute("cart");

		if (cart == null)
		{					
			try
			{
				Context context = new InitialContext();
				CartHome cartHome = (CartHome)context.lookup("Cart");
				cart = cartHome.create();			
				pageContext.getSession().setAttribute("cart", cart);
			}
			catch (NamingException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (CreateException e)
			{
				throw new JspException(e.getMessage());
			}
			catch (RemoteException e)
			{
				throw new JspException(e.getMessage());
			}
		}
		
		try
		{			
			String countParam = pageContext.getRequest().getParameter("count");
			if (countParam == null)
			{
				cart.addProduct(product);
			}
			else
			{
				cart.updateProduct(product, Integer.parseInt(pageContext.getRequest().getParameter("count")));
			}
		}
		catch (NumberFormatException e)
		{
			try
			{
				pageContext.getOut().println("Incorrect Number Format");
			}
			catch (IOException e2)
			{
				e2.printStackTrace();
			}
		}
		catch (java.rmi.RemoteException e)
		{
			e.printStackTrace();
		}
		return SKIP_BODY;		
	}    
}
