<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="http://www.w3.org/TR/xhtml1"
                version="1.0">

	<xsl:strip-space elements="doc chapter section"/>
	<xsl:output method="xml" indent="yes"/>

	<xsl:template match="doc">
		<html>
			<body bgcolor="#ffee77">
				<font face="Arial, Helvetica, sans-serif" size="+1"><b><xsl:value-of select="title"/></b></font>
				<table width="100%" border="0" cellpadding="1" bgcolor="#000000">
					<tr> 
						<td> 
							<table width="100%" border="0">
								<xsl:apply-templates select="items"/>
							</table>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="items">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="items/item">
		<tr bgcolor="#ffffff"> 
			<td>
				<form target="cart" action="cart.jsp" method="get" name="">
					<table width="100%" border="0">
						<tr> 
							<td width="3%"></td>
							<td width="71%"><font face="Arial, Helvetica, sans-serif"><xsl:value-of select="@name"/> 
								Price: $<xsl:value-of select="@price"/></font>
							</td>
							<td width="26%"></td>
						</tr>
						<tr> 
							<td width="3%"></td>
							<td width="71%"> 
								<div align="right">
									<input type="Submit" name="action" value="Add to cart"/>
									<input type="Hidden" name="product" value="{@isbn}"/>
								</div>
							</td>
							<td width="26%"></td>
						</tr>
				    </table>
				</form>
			</td>
		</tr>          
	</xsl:template>

</xsl:stylesheet>

