package com.wrox.projsp.annexeC;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

public class CookieServlet extends HttpServlet {
  String nomEntreprise;
  String valeur = "";

  // La mthode doGet() est appele lors de l'invocation de la servlet.
  // Elle renvoie un formulaire simple au client.

  public void doGet(HttpServletRequest requete,
                    HttpServletResponse reponse) throws ServletException,
                    IOException {

    // regarder s'il existe un cookie, et en extraire la valeur si tel est le cas.

    Cookie[] cookies = requete.getCookies();
    for (int i = 0; i < cookies.length; ++i) {
      String  nom = cookies[i].getName();
      if ( nom != null && nom.equals("nomEntreprise")) {
        valeur = cookies[i].getValue();
      }
    }

    // Dfinir le type de contenu comme html

    reponse.setContentType("text/html");

    // Ouvrir un flux de sortie caractres vers la machine cliente et crire
    // la rponse. S'il existait un cookie, la zone de texte est initialise
    // avec sa valeur. Sinon, la zone de texte est vierge.
    // Remarquez que la valeur transmise  la zone de texte est place entre 
    // guillemets (double-quotes) afin de permettre une chane de plusieurs mots.

    char dq = '\"';

    PrintWriter pw = reponse.getWriter();
    pw.println("<HTML> <HEAD> <TITLE> Exemple de Cookie </TITLE>");
    pw.println("</HEAD><BODY>");
    pw.println("<FORM METHOD=POST>");
    pw.println("Nom entreprise <INPUT TYPE=TEXT name=nom VALUE=" + dq
               + valeur + dq + "><BR>");
    pw.println("<INPUT TYPE=SUBMIT VALUE=Soumettre>");
    pw.println("</FORM></BODY></HTML>");
    pw.close();
  }
  // La mthode doPost() reoit le formulaire du client et envoie une 
  // confirmation en retour. Elle crit galement un cookie renfermant la 
  // chane saisie dans la zone de texte.

  public void doPost(HttpServletRequest requete,
                     HttpServletResponse reponse) throws ServletException,
                     IOException {

    // Rcupre le contenu de la zone de texte.

     nomEntreprise = requete.getParameter("nom");

    // Cre un cookie renfermant le contenu de la zone de texte.
    // Le cookie est ajout  la rponse, sa dure de vie tant
    // fixe  5 minutes.

    Cookie nomCookie = new Cookie("nomEntreprise", nomEntreprise);
    nomCookie.setMaxAge(300);
    reponse.addCookie(nomCookie);

    reponse.setContentType("text/html");

    // Ouvre le flux de sortie caractres vers la machine cliente et crit
    // la rponse

    PrintWriter pw = reponse.getWriter();
    pw.println("<HTML> <HEAD> <TITLE>" + nomEntreprise
               + " information </TITLE>");
    pw.println("</HEAD><BODY>");
    pw.println("Entreprise : " +  nomEntreprise + "<BR>");
    pw.println("</BODY></HTML>");
    pw.close();
  }
}