package com.wrox.projsp.annexeC;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

public class HttpResponseServlet extends HttpServlet {
  String login;
  boolean valide = false;

  // La mthode doGet() est appele lorsque l'utilisateur clique sur le 
  // bouton "Soumettre" dans la page web HttpResponseServlet.html.
  // Elle lit le nom d'utilisateur depuis la chane de requte et renvoie 
  // une rponse au client.

  public void doGet(HttpServletRequest requete,
                    HttpServletResponse reponse) throws ServletException,
                    IOException {

    // Extrait le nom d'utilisateur de la chane de requte et le compare 
    //  une entre valide.

    login = requete.getParameter("login");

    if (login.equals("palmer")) {
      valide = true;
    }

    // Si le nom d'utilisateur est valide (quivalent  "palmer"), une rponse est
    // renvoye au client. Si le nom est invalide, l'objet 
    // HttpSerlvetRequest redirige le client vers la page 
    // de connexion HTML.

    if (valide) {
      reponse.setContentType("text/html");
      PrintWriter pw = reponse.getWriter();
      pw.println("<HTML> <HEAD> <TITLE>Exemple de HttpRequest</TITLE>");
      pw.println("</HEAD><BODY>");
      pw.println("Bienvenue ");
      pw.println("</BODY></HTML>");
      pw.close();
    } else {
      String str = "/projsp/annexeC/HttpServletResponse.html";
      reponse.sendRedirect(reponse.encodeRedirectURL(str));
    }
  }
}