package com.wrox.projsp.annexeC;
import javax.servlet.*;
import java.io.*;
import java.util.*;

public class InitServlet extends GenericServlet {
  String fichier, str;

  // L'objet ServletConfig transmis  la mthode init() sert  rcuprer
  // la valeur associe au paramtre d'initialisation "nomFichier".

  public void init(ServletConfig config) throws ServletException {
     fichier = config.getInitParameter("nomFichier");
  }

  public void service(ServletRequest request, ServletResponse response)
          throws ServletException, IOException, FileNotFoundException {
    response.setContentType("text/html");
    PrintWriter pw = response.getWriter();

    // Si le paramtre d'initialisation est lu correctement, sa valeur 
    // sert  ouvrir un fichier. Le contenu de ce dernier est alors envoy
    // vers la machine cliente.

    if ( fichier != null) {
      BufferedReader br = new BufferedReader(new FileReader(fichier));
      while ((str = br.readLine()) != null) {
        pw.println("<B>" + str + "<BR>");
      }
    } else {
      pw.println("Le paramtre d'initialisation n'existe pas");
    }
    pw.close();
  }
}