package com.wrox.projsp.annexeC;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

public class SessionServlet extends HttpServlet {

  // La mthode doGet() est appele lors de l'invocation de la servlet.
  // Elle renvoie un formulaire simple vers le client, contenant deux boutons 
  // un pour incrmenter le compteur et l'autre pour le remettre  zro.

  public void doGet(HttpServletRequest requete,
                    HttpServletResponse reponse) throws ServletException,
                    IOException {

    reponse.setContentType("text/html");

    PrintWriter pw = reponse.getWriter();
    pw.println("<HTML> <HEAD> <TITLE> Exemple de Cookie </TITLE>");
    pw.println("</HEAD><BODY>");
    pw.println("<FORM METHOD=POST>");
    pw.println("<INPUT TYPE=SUBMIT NAME=ajouter VALUE=Ajouter><BR>");
    pw.println("<INPUT TYPE=SUBMIT NAME=effacer VALUE=Vider><BR>");
    pw.println("</FORM></BODY></HTML>");
    pw.close();
  }

  // La mthode doPost() est appele lorsque l'utilisateur clique
  // sur l'un des deux boutons.
  //
  // Cet exemple est conu pour s'excuter sous l'API Java Servlet 2.1.
  // Avec la version 2.2, la mthode putValue() devrait tre remplace par 
  // setAttribute() et la mthode getValue() par getAttribute()

  public void doPost(HttpServletRequest requete,
                     HttpServletResponse reponse) throws ServletException,
                     IOException {

    // Un objet HttpSession est cr s'il n'existe pas dj. Si le client
    // n'a pas encore accd  la servlet, un objet Counter est cr et
    // li  la session. Cet objet Counter est renvoy  l'aide de la mthode
    // getValue()  chaque fois qu'un accs est effectu vers la servlet.

    HttpSession session = requete.getSession(true);
    if (session.isNew()) {
      session.putValue("compte", new Compteur(0));
    }
    Compteur compteur = (Compteur) session.getValue("compte");
    // Si le bouton "Ajouter" est press, le compteur est incrment.
    // Si le bouton "Vider" est press, le compteur est vid.

    if (requete.getParameter("ajouter") != null) {
      compteur.ajouterUn();
    } else {
      compteur.effacer();
    }

    reponse.setContentType("text/html");

    // Ouvre un flux de sortie de type caractre vers la machine cliente 
    // et crit la valeur actuelle du compteur.  Il y a galement un lien 
    // hypertexte pour revenir  la page des boutons.

    char dq = '\"';

    PrintWriter pw = reponse.getWriter();
    pw.println("<HTML> <HEAD> <TITLE> Exemple de session </TITLE>");
    pw.println("</HEAD><BODY>");
    pw.println("montant actuel : " + compteur.getCompte() + "<BR>");
    pw.print("<A HREF=" + dq);
    pw.print(requete.getRequestURI());
    pw.println(dq + ">Retour  la page des boutons</A>");
    pw.println("</BODY></HTML>");
    pw.close();
  }
}