package com.wrox.projsp.ch02;

import java.applet.*;
import java.awt.*;

public class TestApplet extends Applet implements Runnable {

  AudioClip audio;
  boolean play = false;
  String color = "black";
  int rgbcolor = 0;
  String speed = "slow";
  Thread onOff;

  public void init() {
    if (getParameter("sound").equals("on")) {
      play = true;
      audio = getAudioClip(getCodeBase(), "spacemusic.au");  
    }
    speed = getParameter("speed");
    color = getParameter("color");

    if (color.equals("blue")) 
      rgbcolor = 0x0000FF;
    else if (color.equals("red")) 
      rgbcolor = 0xFF0000;
    else if (color.equals("green")) 
      rgbcolor = 0x00FF00;
  }

  public void start() {
    startOnOff(true);
    if (play)
      audio.loop();
  }

  public void stop() {
    startOnOff(false);
    if (play)
      audio.stop();
  }

  void startOnOff(boolean start) {
    if (start) {
      onOff = new Thread(this);
      onOff.start();
    } else
      onOff = null;
  }

  public void run() {
    int delay = 100;
    if (speed == "slow") 
      delay = 40;
    else if (speed == "fast")
      delay = 20;

    while (Thread.currentThread() == onOff) {
      try {

        repaint();
        onOff.sleep(delay);

      } catch (InterruptedException e) {}

    }
  }

  public void paint(Graphics g) {
    g.setColor(new Color(rgbcolor));
    g.drawString("Pour gravir l'chelle, dmarrez en bas de l'escalier", 20, 90);
  }

  String[][] parameterInfo = {
    {"color", "string", "Color of the text - blue, red or green"},
    {"speed", "string", "Speed of flashing text - fast, slow, v. slow by default"},
    {"sound", "string", "Sound played"}
  };

  public String[][] getParameterInfo() {
    return parameterInfo;
  }
}