package com.wrox.projsp.ch04;

import java.io.*;
import java.util.*;
import java.beans.*;
import java.sql.*;
import javax.servlet.http.*;

public class ConnectionManager implements AppConstants {
  /** le commutateur boolen de dbogage - par dfaut, false */
  private boolean debug = false;
  protected Connection con;
  protected String driver;
  protected String passwd;
  protected String url;
  protected String user;
  protected DebugWriter writer;
  PropertyChangeSupport pcs;

  public ConnectionManager() {
    pcs = new PropertyChangeSupport(this);
    writer = new DebugWriter();
  }
  
  public void setDriverClass(String s) {  
    driver = s;
    try {
      Class.forName( driver ).newInstance();
    } catch (Exception ex) {
      pcs.firePropertyChange(driverClass, null, ex);
      if (debug) {
        writer.writeDebug("Erreur lors du paramtrage du pilote : " + ex);
      }
    }
  }
  
  public void setConnectionUrl(String s) {
    url = s;
  }

  public void setDebug(String b) {
    debug = b.equals("true");
  }
  
  public void addPropertyChangeListener(PropertyChangeListener l){
    pcs.addPropertyChangeListener( l );
  }

  public void removePropertyChangeListener(PropertyChangeListener l){
    pcs.removePropertyChangeListener( l );
  }
  
  public void processRequest(HttpServletRequest req){
    user = req.getParameter(userId);
    passwd = req.getParameter(password);
    if (debug) {
      if (user == null || user.equals("") ) {
        writer.writeDebug("Paramtre Id utilisateur vide");
      }
      if (passwd == null || passwd.equals("") ) {
        writer.writeDebug("Paramtre mot de passe vide");
      }
    }
  }
  
  public void logon() {
    try {
      con = DriverManager.getConnection( url, user, passwd );
      pcs.firePropertyChange(connection, null, con);
      if (debug) {
				writer.writeDebug("Connexion russie ! URL: " + url +" Driver: " + driver + "  User: " + user + " Pwd: " + passwd);
      }
    } catch(Exception ex) {
      pcs.firePropertyChange( conError, null, ex);

      if (debug) {
        writer.writeDebug("chec de la connexion ! URL: " + url +" Driver: " + driver + "  User: " + user + " Pwd: " + passwd + ex.getMessage());
      }
    }
  }

  // Mthodes utiles non dcrites dans l'ouvrage
  public void setUserId(String s){
        user = s;
  }
  public void setPassword(String s){
        passwd = s;
  }
  public String getDriverClass(){
       return driver;
  }


}