package com.wrox.projsp.ch04;

import java.io.*;
import java.util.Date;

public class DebugWriter {

public void writeDebug(String s){
    writeDebug(s, debugFile);
}
 
public void setDebugFileName(String s){
    debugFile = s;
}

private String debugFile = "errors.log";
 
public void writeDebug(String s, String sFile){
    FileOutputStream fos = null;
    try{
      //vrification de l'existence du fichier
      File f = new File(sFile);
      if (!f.exists()) { 
        fos = new FileOutputStream( f );
      } else {
        //vous voulez ajouter l'entre  la fin du fichier
        fos = new FileOutputStream( sFile, true);
      }
      s += "\n";
      //Insrer en en-tte de la ligne une chane date-heure
      fos.write((new Date( System.currentTimeMillis() ).toString() +
                " : " + s).getBytes() );
    } catch(Exception ex) {
      System.out.println("criture d'erreur dans journal de dbogage : "+ex);
    } finally {
      try {
        fos.close();
      } catch(Exception ex){}
    }
  }
}