package com.wrox.projsp.ch04;

import java.io.*;
import java.util.*;
import java.beans.*;
import java.sql.*;
import javax.servlet.http.*;
import javax.servlet.jsp.JspWriter;

public class JspApp implements PropertyChangeListener, AppConstants {
	
  public JspApp() {
    writer = new DebugWriter();
    //fixer le locale par dfaut et obtenir son texte associ
    currentLocale = Locale.getDefault();
    updateBundle();
  }

	public boolean getDebug() {
		return debug;	
	}
	
	public void setDebug(String b){
        debug = b.equals("true");
    }
 	public String getSqlString(){
		return sql;
	}
	public String getUpdatedString() {
	    String updated;
	    if (edited < 0 ){
	        return bundle.getString("editedNone");
	    }
	    else{
		    return String.valueOf( edited ) +
		                bundle.getString( "editedUpdate");
		}
	}

	   
  public void propertyChange(PropertyChangeEvent evt) {
    String prop = evt.getPropertyName();

    //regardez s'il existe une connexion
		if (prop.equals(connection)) {
	    //ok, actualisez la connexion locale
	
	    try {
		    //vrifiez qu'il s'agit bien d'une connexion
				con = (Connection)evt.getNewValue();
	    } catch(Exception ex) {
	    	handleConError(ex);
	    }
	  } else if (prop.equals(conError)) {
      //connexion incorrecte
				try {
        	if (debug) {
          	handleConError( (Exception)evt.getNewValue() );
        	}
      	} catch(Exception ex) { 
        	// pas d'exception dans l'objet handle 
        	if (debug) {
          	handleConError( ex );
        	}
      	}
    	}
  }

  protected void handleConError(Exception ex) {
    writer.writeDebug("Erreur de connexion  la base de donnes : "+ ex.getMessage() );
  }
  
  public void setConnectionManager(ConnectionManager cm) {
    if (cm != null) {
      cm.removePropertyChangeListener( this );
      conMan = cm;
      cm.addPropertyChangeListener( this );
      if (debug) {
        writer.writeDebug("JspApp; Connection manager dfini "
                          + cm.toString());
      }
    } else {
      if (debug) {
        writer.writeDebug("JspAPP; Tentative de cration d'un connection manager null");
      }
    }
  }
  
  public void setQueryType(String s) {
    selectQuery = (s.equalsIgnoreCase(selectType) );
  }

	public void setSqlString(String s) {
  	sql = s;
	}
	
	public boolean isConnected() {
    return (con != null);
  }

  public void processRequest(HttpServletRequest req, JspWriter out) {
  	if (sql == null || sql.equals("")) {
      try{
        out.write( bundle.getString( "NoSQL") );
      } catch(Exception ex){
        //inutile de l'envoyer vers debug msg - vident
        return;
      }
    }
    PreparedStatement ps = null;
    try {
      ps = con.prepareStatement(sql);
    } catch(Exception ex) {
      if (debug) {
        handleException(ex);
      }
      return;
    }
//essayez maintenant de dfinir les paramtres sql  partir de ceux de la requte
    int count = 0;      
    String sqlParam, paramValue;
    boolean set = true;
    while (set) {
      count++;
      sqlParam = paramBase + String.valueOf( count );
      if (sqlParam == null) {
        set = false;
        continue;
      }
      paramValue = req.getParameter( sqlParam );
      if (paramValue == null){
        set = false;
        continue;
      } else {
        //liminez tout espace superflu
        paramValue = paramValue.trim();
      }
      try {
        ps.setString( count, paramValue );
      } catch(Exception ex) {
        //handle ex
        set = false;
        continue;
      }
    }
    //excuter le sql
    try {
      if (selectQuery) {
        ResultSet rs = ps.executeQuery();   
        updateResults( rs );
      } else {
        //stocker le nombre d'enregistrements modifis dans la variable edited

        //redfinir edited afin d'y stocker -1 en cas d'erreur
edited = -1;
        //puis fixer edited  la nouvelle valeur
        edited = ps.executeUpdate();
      }
    } catch(Exception ex) {
      if (debug) {
        handleException(ex);
      }
    }
  }

private void updateResults(ResultSet rs) {
    //rinitialiser le vector et son traceur
    resultElement = 0;
    resultsVector.removeAllElements();
    try {
      ResultSetMetaData rsmd = rs.getMetaData();
      int count = rsmd.getColumnCount();
      while (rs.next() ){
        for (int i=0; i <= count ; i++)
        resultsVector.addElement( rs.getString( i+1 ) );

        //ne grer que la premire ligne - ignorer le reste 
        //en cas d'utilisation de jdk1.2 , servez-vous des lignes suivantes
        //if (rs.isFirst() )
        //break;
        //Avec jdk1.1 vous avez la premire ligne : cela suffit.
        break;
      }
    }
    catch(Exception ex) {
      if (debug) {
        handleException(ex);
      }
    }
  }
  
  public String getNext(){
    try {
			//wrapper le rsultat sous forme de chane
      //L'lment result est incrment pour la prochaine utilisation
      String result = (String)resultsVector.elementAt(resultElement++);
      result = (result == null) ? "" : result;
      return "\"" + result + "\"";
    } catch(Exception ex) {
      if (debug) {
        writer.writeDebug("Erreur de rcupration des donnes  " + 
          String.valueOf( resultElement) +
          " in resultsVector: " + ex.getMessage() );
      }
      return "";
    }
  }

public void setLocale(Locale loc) {
    currentLocale = loc;
    updateBundle();
  }

  private void updateBundle() {
//obtenir le bundle
    try {
      bundle = PropertyResourceBundle.getBundle(defaultBundle,
                                                currentLocale);
    } catch(Exception ex) {
      if (debug) {
        writer.writeDebug("Erreur de rcupration du bundle " + ex.getMessage() );
      }
    }
  }

public String getConStatus() {
    if (isConnected()) {
      return bundle.getString( "Logon" );
    } else {
      return bundle.getString( "LogonFail" );
    }
  }

	// Methodes non dcrites dans l'ouvrage
	private void handleException(Exception ex){
	    if (ex instanceof SQLException){
	      SQLException dbex = (SQLException)ex;
		    StringBuffer sMsg = new StringBuffer();
		    while (dbex != null) {
		        sMsg.append ("Rsultat SQL: " +
				    dbex.getSQLState ()+"\n" +
			    "Message:  " +
				    dbex.getMessage ()+"\n"+
			    "Vendeur:   " +
				    dbex.getErrorCode ()+"\n");
			    dbex = dbex.getNextException ();
		    }
		    writer.writeDebug(sMsg.toString());
		}
		else{
		    writer.writeDebug("Traitement d'erreur: "+ex.getMessage());
		}
	}



  protected ResourceBundle bundle;
	protected Connection con;
	ConnectionManager conMan;
  protected Locale currentLocale;
	private boolean debug = false;
	protected String defaultBundle = "com/wrox/projsp/ch04/JspAppBundle";
	protected DebugWriter writer;	
	private boolean selectQuery = true;
	private int resultElement = 0;
	private Vector resultsVector = new Vector();
	protected String sql;
	private int edited = -1;

}