import java.beans.*;

class TestBean {
  private int  height;
  private String description;
  protected boolean debug = false;
 PropertyChangeSupport pcs;
  
public TestBean(){
    pcs = new PropertyChangeSupport(this);
}
 
  
public void setHeight (int i){
  height = i;
}

public int getHeight (){
  return height;
}

public void setDescription(String s){
  pcs.firePropertyChange("description", description, s);
  description = s;
}

public String getDescription (){
  return description;
}

public void setDebug (boolean b){
  debug = b;
}

public boolean isDebug (){
  return debug;
}

public void addPropertyChangeListener(PropertyChangeListener l){
  pcs.addPropertyChangeListener(l);
}

public void removePropertyChangeListener(PropertyChangeListener l ){
  pcs.removePropertyChangeListener(l);
}

public void printStatus() {
  System.out.println("Height is " + height);
  System.out.println("Description is " + description);
  System.out.println("Debug is " + debug);
}
  
}