package com.wrox.projsp.ch05;

import java.util.Vector;

public class Catalog {
  private Vector items = new Vector();

  synchronized public Vector getItems() {
    return items;
  } 

  synchronized public Item getItem(String itemId) {
    int index = Integer.parseInt(itemId);
    return (Item)items.elementAt(index);
  } 

  synchronized public void setItem(Item item, String itemId) {
    int index = Integer.parseInt(itemId);
    items.set(index, item);
  } 

  public Catalog() {
    /**
     * Ici devrait se trouver le code JDBC permettant la connexion et la rcupration 
     * des informations d'inventaire, la cration des objets Item et leur stockage
     */
    items.addElement(new Item("0", "Brosse  dents", (float)10, true, 100));
    items.addElement(new Item("1", "Peigne", (float)1, true, 100));
    items.addElement(new Item("2", "Rasoir", (float)13, true, 1000));
    items.addElement(new Item("3", "Aprs-rasage", (float)10, true, 900));
    items.addElement(new Item("4", "Eau de Cologne", (float)25, true, 133));
    items.addElement(new Item("5", "Mousse  raser", (float)12, true, 353));
    items.addElement(new Item("6", "Lame de rasoir", (float)9, true, 333));
    items.addElement(new Item("7", "Porte-crayon", (float)0.99, true, 222));
    items.addElement(new Item("8", "Mascotte Java", (float)19, true, 343));
    items.addElement(new Item("9", "Rasoir lectrique", (float)100, true, 884));
  }
}