package com.wrox.projsp.ch05;

import java.util.Date;
import javax.servlet.http.*;
import java.io.*;

public class Order implements HttpSessionBindingListener {

  private String itemIds[];
  private long orderId;
  private User user;
  private boolean processed = false;

  public Order(User user) {
    orderId = System.currentTimeMillis();
    this.user = user;
  }

  public void setItemIds(String itemIds[]) {
    this.itemIds = itemIds;
  } 

  public String[] getItemIds() {
    return itemIds;
  } 

  public long getOrderId() {
    return orderId;
  } 

  public boolean isProcessed() {
    return processed;
  } 

  public void complete(Catalog catalog) {
    // modifier les dtails du catalogue
    for (int i = 0; i < itemIds.length; i++) {
      Item item = catalog.getItem(itemIds[i]);
      item.setQuantity_in_stock(item.getQuantity_in_stock() - 1);
      catalog.setItem(item, itemIds[i]);
    }

    // Envoyer au service Expdition
    processed = true;
  } 

  public User getUser() {
    return user;
  } 

  public void valueBound(HttpSessionBindingEvent event) {}

  public void valueUnbound(HttpSessionBindingEvent event) {
    if (!processed) {
      doLog();
    } 
  } 

  private void doLog() {
    try {
      PrintWriter log = new PrintWriter(
                        new FileWriter("../logs/shopping.txt"),
                                       true);
      log.println("Commande incomplte numro " + orderId +
                  " for user " + user.getUserId());
      log.close();
    } catch(IOException e) {}
  } 

  public String toString() {
    String temp = "";

    for (int i = 0; i < itemIds.length; i++) {
      temp += " , " + itemIds[i];
    }

    return "order id :" + orderId + "<br>Items ids : " + temp;
  } 
}