package com.wrox.projsp.ch07;
import java.util.*;
import java.net.URL;
import java.io.*;
public class bench implements Runnable {
  static  String TESTURL =
    "http://169.254.171.246:8080/wroxjsp/ch07/dbinfemp.jsp?eid=";
  static int MAXRESID = 8;
  static int MAXTHREADS = 3;
  static int myCounter =0;

  static int MAXHITS = 1000;
  static boolean terminate = false;

  String hitURL;
  URL myURL;
  BufferedReader myReader;
  String testStr;
  Random myRnd;
  InputStream myStream;
  long myStart;

  public bench() {
    myStart = System.currentTimeMillis();
    myRnd = new Random();
  }

  public void run() {
    while(true) {

      try {
        hitURL = TESTURL + (myRnd.nextInt(MAXRESID) + 1);
        myURL = new URL(hitURL);
        myStream = myURL.openStream();
        myReader = new BufferedReader(new   InputStreamReader(myStream));
        testStr = myReader.readLine();
        while (testStr != null) {
          testStr = myReader.readLine();
        }
      } catch (Exception e) {
        e.printStackTrace();
      } finally {
        try {
          myStream.close();
        } 
        catch(Exception e) {
          e.printStackTrace();
        }  
      }
  
      addOne();
        if (terminate) break;
    } // du while
  }

  public synchronized void addOne() {
    if (!terminate) {
      myCounter++;
      if (myCounter >= MAXHITS) {
       System.out.println("Temps total ecoule avec " + MAXTHREADS + " threads pour "
          + MAXHITS + " touches : " + (System.currentTimeMillis() - myStart)
          + " ms.");
      terminate = true;
    }
  }
}

  public static void main (String args[]) {
    if (args.length < 4) {
      System.out.println
        ("Syntaxe: bench <URL> <plage subst> <nb max touches> <nb max threads>");
      System.exit(1);
    }
      
    try {
      TESTURL = args[0];
      MAXRESID = Integer.parseInt(args[1]);
      MAXHITS = Integer.parseInt(args[2]);
      MAXTHREADS = Integer.parseInt(args[3]);
      System.out.println("Debut d'acces a l'URL : " + TESTURL);
      System.out.println("jusqu a " + MAXHITS + " touches en utilisant " +
        MAXTHREADS + " threads, et une plage aleatoire de " + MAXRESID);
         
      for (int i=0; i<MAXTHREADS; i++) {
        new Thread(new bench()).start();
      }
    } catch(Exception e) {
      e.printStackTrace();
      System.exit(1);
    }

  }
}