package com.wrox.projsp.ch08;

import java.awt.Color;
import java.util.HashMap;

public class AlphabetCode
{
   private HashMap map;
   char c = 0;

   // Pour l'initialisation
   int premiereLettre = 0;
   int alphabetLongueur = 0;

// variables couleur
   float s = 0.9f;
   float b = 0.9f;
   public AlphabetCode() {}

   public void setPremiereLettre(char premiereLettre)
   {
      this.premiereLettre = premiereLettre;
   }

   public void setAlphabetLongueur(int longueur)
   {
      alphabetLongueur = longueur;
   }

   public void initMap()
   {
      if (map!=null)
         // Si appel deux fois, par accident, 
         //  et qu'il existe un objet map, revenir
         return;
      else
         // Crer et remplir le tableau avec les paires caractre/couleur
         map = new HashMap(alphabetLongueur*2);

      for(int i = 0; i < alphabetLongueur; i++)
      {
         this.c = (char)(premiereLettre + i);
         float h = (float)i/alphabetLongueur;
         this.map.put(new Character(c), Color.getHSBColor(h, s, b));
      }
   }

   public void setCaractere(char caractereSuivant)
   {
      c = caractereSuivant;
   }

   public char getCaractere()
   {
      return c;
   }

   public String getCouleur()
   {
      Color rgb = (Color)map.get(new Character(this.c));
      StringBuffer htmlColor = new StringBuffer(
                            Integer.toHexString(rgb.getRGB() 
                                                & 0x00ffffff));
      // toHexString() ne conserve pas les zros de tte, si bien qu'il faut les rajouter
      // s'il en manque...
      if (htmlColor.length() != 6) {
         htmlColor.insert(0, "\"#00");
      } else 
         htmlColor.insert(0, "\"#");

      htmlColor.append("\"");

      return htmlColor.toString();
   }
}