package com.wrox.projsp.ch08;

import java.awt.Color;
import java.util.HashMap;
import java.io.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class AlphabetTag extends BodyTagSupport {
  HashMap map;
  char c = 0;

  // Pour l'initialisation
  int premiereLettre = 0;
  int alphabetLongueur = 0;
  int ligne = 0;

  // Variables de couleurs
  float s = 0.9f;
  float b = 0.9f;

  // Position
  int row = 0;
  int colonne = 0;

  public void setPremiereLettre(String start) {
    premiereLettre = start.charAt(0);
  }

  public void setAlphabetLongueur(String longueur) {
    alphabetLongueur = Integer.valueOf(longueur).intValue();
  }

  public void setLigne(String repeat) {
    ligne = Integer.valueOf(repeat).intValue();
  }

  public int doStartTag() throws JspTagException {
    // Crer et remplir le tableau avec les paires caractre/couleur
    map = new HashMap(alphabetLongueur*2);
 
    for(int i = 0; i < alphabetLongueur; i++) {
      this.c = (char)(premiereLettre + i);
      float h = (float)i/alphabetLongueur;
      this.map.put(new Character(c), Color.getHSBColor(h, s, b));
    }

    return EVAL_BODY_TAG;
  }

  public void doInitBody() {
    setOutputAttributes();
  }

  public int doAfterBody() throws JspTagException {
    try {
      // vous tes dans une ligne, et devez obtenir la prochaine lettre.
      if (colonne < alphabetLongueur) {
        setOutputAttributes();
        return EVAL_BODY_TAG;
      } else if (colonne == alphabetLongueur && row < ligne) {
        // Il faut une nouvelle ligne
        colonne = 0;
        setNewLine();
        setOutputAttributes(); 

        return EVAL_BODY_TAG;
      } else { // if (colonne == alphabetLongueur && row == ligne) {
// C'est termin - crire la sortie vers le out de niveau suprieur
        BodyContent body = getBodyContent();
        body.writeOut(getPreviousOut());

        return SKIP_BODY;
      }
    } catch (IOException ex) {
      throw new JspTagException(ex.toString());
    }
  }

  public int doEndTag() throws JspTagException {
    return EVAL_PAGE;
  }

  public void release() {
    map = null;
  }

  public void setOutputAttributes() {
    setCaractere((char)(premiereLettre + (alphabetLongueur - row + colonne)%alphabetLongueur));

    pageContext.setAttribute("caractere", 
                             new Character(getCaractere()).toString());
    pageContext.setAttribute("couleur", getCouleur());

    colonne++;
    if (colonne == alphabetLongueur)
      row++;
  }

  public void setNewLine() throws JspTagException {
    try {
      // Utiliser un out imbriqu
      BodyContent body = getBodyContent();

      body.println("<BR>");
      body.newLine();
    } catch(IOException e) {
throw new JspTagException("Problmes avec BodyContent: " + e);
    }
  }

public void setCaractere(char caractereSuivant)
   {
      c = caractereSuivant;
   }

   public char getCaractere()
   {
      return c;
   }

   public String getCouleur()
   {
      Color rgb = (Color)map.get(new Character(this.c));
      StringBuffer htmlColor = new StringBuffer(
                            Integer.toHexString(rgb.getRGB() 
                                                & 0x00ffffff));
      // toHexString() ne conserve pas les zros de tte, si bien qu'il faut les rajouter
      // s'il en manque...
      if (htmlColor.length() != 6) {
         htmlColor.insert(0, "\"#00");
      } else 
         htmlColor.insert(0, "\"#");

      htmlColor.append("\"");

      return htmlColor.toString();
   }

}