package com.wrox.projsp.ch08;

import java.awt.Color;
import java.util.HashMap;
import java.io.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public class AlphabetTag2 extends BodyTagSupport {
  HashMap map;
  char c = 0;

  // Pour l'initialisation
  char premierCaractere = 0x41;
   int longueurLigne = 0;
   int ligne = 0;

  // Variables de couleurs
  float s = 0.9f;
  float b = 0.9f;

  // Position
  int row = 0;

  public void setPremierCaractere(String start) {
    premierCaractere = start.charAt(0);
  }

  public void setLongueurLigne(String longueur) {
    longueurLigne = Integer.valueOf(longueur).intValue();
  }

  public void setLigne(String repeat) {
    ligne = Integer.valueOf(repeat).intValue();
  }

  public int doStartTag() throws JspTagException {
    // Crer et remplir le tableau avec les paires caractre/couleur
    map = new HashMap(longueurLigne*2);
 
    for(int i = 0; i < longueurLigne; i++) {
      this.c = (char)(premierCaractere + i);
      float h = (float)i/longueurLigne;
      this.map.put(new Character(c), Color.getHSBColor(h, s, b));
    }

    return EVAL_BODY_TAG;
  }

  
  public int doAfterBody() throws JspTagException {
    BodyContent body = getBodyContent();

    try {
      if (row < ligne) {
        setRowAttributes();
      } else { // si (row == ligne) {

        body.writeOut(getPreviousOut());
        return SKIP_BODY;
      }
    } catch (IOException ex) {
      throw new JspTagException(ex.toString());
    }

    return EVAL_BODY_TAG;
  }

  public int doEndTag() throws JspTagException {
    return EVAL_PAGE;
  }

  public void release() {
    map = null;
  }

  public void setRowAttributes() {
    // Fixs dans pageContext afin que les balises imbriques puissent les atteindre
    pageContext.setAttribute("nombreLigne", new Integer(row).toString());
    pageContext.setAttribute("longueurLigne", new Integer(longueurLigne).toString());
// Incrmente le nombre de ligne pour la fois suivante
    row++;
  }

  public void setNewLine() throws JspTagException {
    try {
      // Utiliser un out imbriqu
      BodyContent body = getBodyContent();

      body.println("<BR>");
      body.newLine();
    } catch(IOException e) {
throw new JspTagException("Problmes avec BodyContent: " + e);
    }
  }

public void setCaractere(char caractereSuivant)
   {
      c = caractereSuivant;
   }

   public char getCaractere()
   {
      return c;
   }


  public void doInitBody() throws JspTagException {
    setRowAttributes();
    pageContext.setAttribute("premierCaractere", new Character(premierCaractere).toString());
  }

	public HashMap getAlphabet() {
    return map;
  }

}