package com.wrox.projsp.ch08;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.sql.*;
import java.util.*;

public class BookStoreSearchTag extends TagSupport implements Tag {

  public void setConnId(String id) {
    connection = id;
  }

  public int doStartTag() throws JspTagException {

    Connection dbConnect = (Connection)pageContext.getAttribute("connection"); 

    if (dbConnect == null) {
      ConnectionTag tag = (ConnectionTag)TagSupport.findAncestorWithClass(this,
                                                          ConnectionTag.class);
      if (tag == null) {
        throw new JspTagException("Un BookStoreSearchTag sans attribute connexion" +
                                  " doit tre imbriqu dans " +
                                  " une balise ConnectionTag");
      }

      // Renvoie la connexion pour cette page
      dbConnect = tag.getConnection();
    }
   
    if (dbConnect == null) {
      throw new JspTagException("Impossible d'obtenir la connexion");
    }

    ResultSet rs;

    try {
      PreparedStatement mystatement = dbConnect.prepareStatement(
                                "SELECT * FROM bookshop ORDER BY Town");
      rs = mystatement.executeQuery();
    } catch(SQLException e) {
      throw new JspTagException("Est-ce la bonne base de donnes ? - " + 
                                "chec de la requte sur la table bookshop " + e);
    }

    // Convertir le ResultSet en une Collection devant tre utilise par la balise form:select 
    // Recherche de la ville pour select
    bookStores = new Vector();

    int contactColumnNumber;
    int townColumnNumber;
    int addressColumnNumber;
    int phoneColumnNumber;

    try{
      contactColumnNumber = rs.findColumn("Contact"); 
      townColumnNumber = rs.findColumn("Town");
      addressColumnNumber = rs.findColumn("Address");
      phoneColumnNumber = rs.findColumn("Phone"); 
    } catch(SQLException e) {
      throw new JspTagException("Est-ce la bonne base de donnes ?" + 
                                "Impossible d'y trouver la table bookshop avec une colonne town" + e);
    }

    try{
      while(rs.next()) {
        // Sert  crer un bean BookStore...
        BookStore bookStore = new BookStore();
// Fixer les dtails...
        bookStore.setContact(rs.getString(contactColumnNumber));
        bookStore.setTown(rs.getString(townColumnNumber));
        bookStore.setAddress(rs.getString(addressColumnNumber));
        bookStore.setPhone(rs.getString(phoneColumnNumber));

        bookStores.add(bookStore);
      }
    } catch(SQLException e) {
      throw new JspTagException("resultset Bookshop non satisfait" + e);
    }

    pageContext.setAttribute("bookstores", bookStores);

    // Passer maintenant au reste de la page...
    return EVAL_PAGE;
  }

  public void release() {
    super.release();
  }

  String statementText;
  String connection;
  String path;
  Vector bookStores;
}