package com.wrox.projsp.ch08;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import java.sql.*;

/**
 * Exemple: un ensemble de balises connection/password/userid/query.
 * Adaptation des exemples JSP 1.1 de Sun
 *
* Ceci est la reprsentation runtime d'une balise connection 
 *
 * ConnectionTag prend en charge le paradigme de programmation suivant. 
 *
 * Dfinition implicite d'une connexion disponible entre les balises de dbut/fin
 * <connection ref="connection"
 *             password="pwd"
 *             userid="uid" >
 * <query....> </query>
 * </connection>
 */

public class ConnectionTag extends BodyTagSupport {

  /**
   * Attributs de cette action :
   *   id (hrit)
   *   ref
   *   userId et password
   */
  /**
   * ref est une rfrence vers une connexion
   */
  public ConnectionTag() {
  }
  
  public void setRef(String s) {
    this.ref = s;
  }

  public String getRef() {
    return this.ref;
  }

  public void setUserId(String uid) {
    userId = uid;
  }

  public void setPassword(String pass) {
    password = pass;
  }

  public int doStartTag() throws JspTagException {
    ref = getRef();
    if (ref == null) {
      throw new JspTagException("attribut ref manquant");
    }
    String tagId = getId();
    if (tagId != null) {
      if (userId == null) {
        throw new JspTagException("userId non encore dfini");
      }
      if (password == null) {
        throw new JspTagException("password non encore dfini");
      }
      if (connection == null) {
        getConnection();
      }
      pageContext.setAttribute(tagId, connection);
    }

    return EVAL_BODY_TAG;
  }

  public int doEndTag() throws JspTagException {
    connection = null;
    return EVAL_PAGE;
  }

  /**
   * Obtenir l'objet connection SQL.
   * Un objet connection ncessite l'userid et le password
   * Essayer d'obtenir la connexion avant que les donnes ne soient
   * disponibles produit une erreur
   */
  public Connection getConnection() throws JspTagException {
    // Il faut renvoyer la connexion s'il en existe dj une. Ce doit tre un singleton.
    // Si vous voulez une autre connexion, utilisez une autre balise...
    if (connection == null) {
      if (userId == null) {
        throw new JspTagException("userId non encore dfini");
      }
      if (password == null) {
        throw new JspTagException("password non encore dfini");
      }
      try {
        // obtenir l'objet connection
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");

        // Chane de base de donnes = 
        connection = DriverManager.getConnection(ref,
                                                 userId,
                                                 password);
      } catch (ClassNotFoundException e) {
        throw new JspTagException("Erreur de chargement du pilote : " + e);
      } catch (SQLException ex) {
        connection = null;
        throw new JspTagException("chec de connexion " + ex);
      }
    }
    return connection;
  }

  public static void main(String[] args) {
  	
  	ConnectionTag ct = new ConnectionTag();
  	ct.setUserId("conn01");
  	ct.setRef("jdbc:odbc:Books"); 
    ct.setUserId("guest");
    ct.setPassword("guest");
    try {ct.getConnection();		
    } catch (Exception e) {System.out.println("Excepton e"+e.toString());}
  }
  
  // Pour en finir
  public String getUserId() { return userId; }
  public String getPassword() { return password; }

  private Connection connection=null;  // l'objet connexion SQL
  private String password;        // mot de passe de la connexion
  private String userId;          // ID utilisateur pour la connexion
  private String ref;             // attribut ref , cens tre une URL JDBC}
}