package com.wrox.projsp.ch08;

import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

import java.util.Date;

public class PageVisitTag3 extends TagSupport {

  public int doStartTag() throws JspTagException {
    Cookie info = null;
		String msg = "Vous visitez cette page pour la premire fois.";

    // Obtenir tous les cookies accompagnant la requte
    Cookie[] cookies = ((HttpServletRequest)pageContext.getRequest()).getCookies();

    for(int i = 0; i < cookies.length; i++) {
      info = cookies[i];
      if (info.getName().equals("MyCookie")) {
        found = true;
        break;
      }
    }

    String newValue = "" + System.currentTimeMillis();

    if (!found) {
      // Crer un nouveau Cookie et dfinir son ge.
      info = new Cookie("MyCookie", newValue );
      info.setMaxAge(60*1);
      info.setPath("/");

      ((HttpServletResponse)pageContext.getResponse()).addCookie(info);
    } else{
      long conv = new Long(info.getValue()).longValue();
      msg = "Vous avez visit cette page pour la dernire fois le " + new Date(conv);

    	// Dfinir la nouvelle valeur du cookie, puis l'ajouter  la rponse
    	info.setValue(newValue);
    	info.setMaxAge(10*24*60*60); // conserver le cookie un mois.

    	// Ajuster le chemin afin que le cookie soit disponible sur tout le serveur
      info.setPath("/");
      ((HttpServletResponse)pageContext.getResponse()).addCookie(info);
    }

    pageContext.setAttribute("msg", msg);

    return EVAL_BODY_INCLUDE;
  }
  
  public int doEndTag() {
    if (!found) {
      // Cette fois, ne pas comparer la date courante et celle du cookie
      return SKIP_PAGE;
    } else
      return EVAL_PAGE;
  }

  boolean found = false;
}