package com.wrox.projsp.ch08;

import java.awt.Color;
import java.util.*;
import java.io.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/*
 * Exemple: the RowTag
 * Aucun attribut n'est obligatoire *
 *
 */
public class RowTag extends BodyTagSupport implements BodyTag {

   private HashMap map;
   char c = 0;
   char premierCaractere = 0x41;
   int ligne = 0;
   int longueurLigne = 0;

   int colonne = 0;

public void setPremierCaractere(String start) {
    premierCaractere = start.charAt(0);
  }

  public void setLongueurLigne(String longueur) {
    longueurLigne = Integer.valueOf(longueur).intValue();
  }
  public void setLigne(String repeat) {
    ligne = Integer.valueOf(repeat).intValue();
  }


   public int doStartTag() throws JspTagException {

    longueurLigne = Integer.parseInt((String)(pageContext.getAttribute("longueurLigne")));
    premierCaractere = ((String)pageContext.getAttribute("premierCaractere")).charAt(0);
    ligne = Integer.parseInt((String)(pageContext.getAttribute("nombreLigne")));

    // alphabetMap est-il li  pageContext ?
    map = (HashMap)pageContext.getAttribute("alphabetMap");

    if (map == null) {
      AlphabetTag2 tag = (AlphabetTag2)TagSupport.findAncestorWithClass(this,
                                       AlphabetTag2.class);
      if (tag == null) {
        throw new JspTagException("Un RowTag sans attribut alphabet " +
                                  " doit tre imbriqu dans un AlphabetTag2");
      }

      // Ncessit d'emprunter cet alphabet ou de le construire  chaque fois... 
      map = tag.getAlphabet();
    }

    if (map == null) {
throw new JspTagException("impossible de trouver l'objet alphabet");
    }

    return EVAL_BODY_TAG;
  }

   public void doInitBody() throws JspTagException {
      setOutputAttributes();
   }
    
   public int doAfterBody() throws JspTagException {
    try {
      if ( colonne < longueurLigne) {
        setOutputAttributes();
      } else { // if (colonne == longueurLigne) {
        colonne = 0;
        BodyContent body = getBodyContent();

        body.println("<BR>");
        body.newLine();
        body.writeOut(getPreviousOut());
        return SKIP_BODY;
      }
    } catch (IOException e) {
      throw new JspTagException(e.toString());
    }

    return EVAL_BODY_TAG;
  }

   public int doEndTag() throws JspTagException {
      map = null;

      return EVAL_PAGE;
   }
   
   public void setCaractere(char caractereSuivant)
   {
      c = caractereSuivant;
   }

   public char getCaractere()
   {
      return c;
   }

   public String getCouleur()
   {
      Color rgb = (Color)map.get(new Character(this.c));
      StringBuffer htmlColor = new StringBuffer(
                            Integer.toHexString(rgb.getRGB() 
                                                & 0x00ffffff));
      // toHexString() ne conserve pas les zros de tte, si bien qu'il faut les rajouter
      // s'il en manque...
      if (htmlColor.length() != 6) {
         htmlColor.insert(0, "\"#00");
      } else 
         htmlColor.insert(0, "\"#");

      htmlColor.append("\"");

      return htmlColor.toString();
   }


   
   public void setOutputAttributes() {
    setCaractere((char)(premierCaractere + (longueurLigne - ligne + colonne)%longueurLigne));

    pageContext.setAttribute("caractere", 
                             new Character(getCaractere()).toString());
    pageContext.setAttribute("couleur", getCouleur());

    colonne++;
    
  }

}