<% /* cookieManager.jsp */ %>
<%!
public void creerMonCookie (
  HttpServletResponse response, 
  String nom, 
  String valeur, 
  int expires
  ) {
  
  // Crer un nouvel objet cookie  partir duquel concevoir votre cookie
  Cookie c = new Cookie(nom, valeur);
  
  // Dfinir la dure de vie de ce cookie
  // exprime en secondes, 
  // si bien que 24 heures = 60*60*24
  c.setMaxAge(expires);
  
  // Envoyer le cookie dans le flux d'en-tte
  response.addCookie(c);
}

public String getMonCookie (
  HttpServletRequest request, 
  String nomCookie
  ) {
  
  // Dfinir le tableau des cookies
  Cookie c[] = request.getCookies();
  
  // Vrifier qu'il existe bien un cookie avec lequel travailler
  if (c != null) {
    for (int i = 0; i < c.length; i ++) { // (1)
      if (c[i].getName().equals(nomCookie)) { // (2, 3)
        return c[i].getValue(); // (4)
      }
    }
  }
  
  // Si rien n'est trouv, ne rien renvoyer
return "";
}
%>
