import java.io.*;
import java.util.*;
public class OverflowOutputStream extends OutputStream {
  StringBuffer buff;
  int size;

  public OverflowOutputStream(int size) {
    this.size = size;
    buff = new StringBuffer(size);
    buff.append(new Date().toString());
    buff.append("| ");
  }


  public OverflowOutputStream() {
    this(32 * 1024);
  }

  public String toString() {
    return buff.toString();
  } 

  public void write(byte[] b) {
    if (buff.length() + b.length > size) {
      trunc();
    } 
    if ((buff.length() > 1) 
            && (buff.charAt(buff.length() - 1)) == '\n') {
      buff.append(new Date().toString());
      buff.append("| ");
    } 
    buff.append(b);
  } 

  public void write(byte[] b, int off, int len) {
    if (buff.length() + b.length > size) {
      trunc();
    } 
    if ((buff.length() > 1) 
            && (buff.charAt(buff.length() - 1)) == '\n') {
      buff.append(new Date().toString());
      buff.append("| ");
    } 
    buff.append(new String(b, off, len));
  } 

  public void write(int b) {
    if (buff.length() + 4 > size) {
      trunc();
    } 
    if ((buff.length() > 1) 
            && (buff.charAt(buff.length() - 1)) == '\n') {
      buff.append(new Date().toString());
      buff.append("| ");
    } 
    buff.append(b);
  } 

  public void reset() {
    buff = new StringBuffer(size);
    buff.append(new Date().toString());
    buff.append("| ");
  } 

  void trunc() {
    buff.delete(0, buff.length() / 2);
  } 
}