package com.wrox.projsp.ch11;

// DBSettings lit les paramtres dans la base de donnes 
import java.io.*;
import java.util.*;
import java.sql.*;

public class DBSettings implements SettingsSource{
  private Connection conn;
  private PreparedStatement pstmt;
  private String query;

  public DBSettings() { 
    // constructeur par dfaut
  }
  
  public synchronized void load (String param) throws IOException {
    // instruction paramtre =  dbName:select 
    int pos = param.indexOf(":");
    if (pos < 1){
      throw new IOException("paramtre invalide");
    }
    String dbName = param.substring(0,pos).trim();
    String select = param.substring(pos+1).trim();

    try{
      String driver = Settings.get("db."+dbName+".driver");
      String URL = Settings.get("db."+dbName+".URL");
          
      String userId = Settings.get("db."+dbName+".user");
    
      String password = Settings.get("db."+dbName+".password");
    
      // peut-tre d'autres proprits...

      Class.forName(driver);
      conn = DriverManager.getConnection(URL,userId,password);

      pstmt=conn.prepareStatement(select);

    }
    catch (SQLException e){
      throw new IOException("paramtre invalide");
    }
    catch (ClassNotFoundException e){
      System.out.println(e.getMessage());
      throw new IOException("paramtre invalide");
    }
  }  
public synchronized void save () throws IOException {
  // rien: actuellement en lecture seule ;-)
  return;
}

  public String getSetting(String cle) {
    String valeur = null;
    try{
      pstmt.clearParameters();
      pstmt.setString(1,cle);
      ResultSet rs = pstmt.executeQuery();
      if (rs.next()){ // seulement la premire ligne
        valeur = rs.getString(1);
      }
      rs.close();
    }
      catch (SQLException e){
    System.out.println(e.getMessage());

    }
    return valeur;
  }
 
  public void setSetting(String key,String valeur) {
    return;
  }
  
  public Enumeration getPropertyNames(){
    Enumeration dummy = null;
    return dummy;
  }
  
  public void finalize(){
    try{
      pstmt.close();
      conn.close();
    }
    catch (SQLException e){}
    catch (NullPointerException e){}
  }

  public static void main(String[] args) {
  // test de main
  try {
	  Settings.getInstance().load(args[0]);
  } catch (IOException e) {
    System.out.println(e.getMessage());
  }
	String userName = "rdur";
  System.out.println("UserPassword "+Settings.get("userpasswords."+userName));
  }
}