package com.wrox.projsp.ch11;
// source par dfaut de paramtres, utilise un fichier de proprits
import java.io.*;
import java.util.*;

public class FileSettings implements SettingsSource{
  private Properties prop = new Properties();
  private String fileName;

  
	public synchronized void load (String param) throws IOException {
	  fileName = Settings.getInstance().translateDirectory(param);
	  File propFile=new File(fileName); 
	  prop.load(new FileInputStream(propFile));
	}
	
  public synchronized void save () throws IOException {
      if (fileName != null){
         File propFile=new File(fileName); 
        prop.store(new FileOutputStream(propFile),"");
      }
  }

  public String getSetting(String cle) {
     return prop.getProperty(cle);
  }
 
  public void setSetting(String cle,String valeur) {
     prop.setProperty(cle,valeur);
  }

  public Enumeration getPropertyNames(){
    return prop.propertyNames();
  }

}