package com.wrox.projsp.ch11;

import java.io.*;
import java.util.*;

public class Settings {
  private static Settings instance;
  private Properties base = new Properties();
  private Hashtable settings = new Hashtable();
  private String baseFile;

  private Settings() {
    // constructeur priv
  } 

  public Settings(String baseFile) throws IOException {

    // constructeur public lorsque l'approche singleton n'est pas utilise
    load(baseFile);
  }

  public static Settings getInstance() {

    if (instance == null) {
      instance = new Settings();
    } 
    return instance;
  }


  public synchronized void load (String file) throws IOException {
    // charger ou actualiser les proprits 
    baseFile = file;
    File propFile=new File(file); 
    base.load(new FileInputStream(propFile));
    System.out.println("Proprietes loades "+base.toString());
    }

  public synchronized void save () throws IOException {
    File propFile=new File(baseFile); 
    base.store(new FileOutputStream(propFile),"");
  }


  public String getSetting(String cle) {
    String index= "";
    int pos;
    String valeur = null;
    
    pos = cle.indexOf(".");
    if (pos > -1){
      index = cle.substring(0,pos);
    }
    if (index.equals("") || index.equals("include") || 
        index.equals("directory"))  {
      //include et directory sont rservs
            
      valeur = base.getProperty(cle);
      return valeur;
    } else {
      cle = cle.substring(pos + 1);
    }
    SettingsSource temp = getSource(index);
    if (temp != null) {
      valeur = temp.getSetting(cle);
    }
    return valeur;
  }

  public static String get(String cle) {
    // mthode servant de raccourci :
    return getInstance().getSetting(cle);
  }
  private SettingsSource getSource(String index) {
    SettingsSource temp = (SettingsSource)settings.get(index);
    if (temp == null){
      String param = base.getProperty("include."+index+".param");
      String sourceType = base.getProperty("include."+index+".sourceType");
      if (sourceType == null){
        // utiliser ce type par dfaut
        sourceType = "com.wrox.projsp.ch11.FileSettings";
      }
      try{
        temp = (SettingsSource)Class.forName(sourceType).newInstance();
        if (param==null) param=index;
        temp.load(param);
        settings.put(index,temp);
      }
      catch (IOException e){
        System.out.println(e.getMessage());
      }
      catch (IllegalAccessException e){
        System.out.println(e.getMessage());
      }
      catch (InstantiationException e){
        System.out.println(e.getMessage());
      }
      catch (ClassNotFoundException e){
        System.out.println(e.getMessage());
      }
    }
    return temp;
  }
  
  public String translateDirectory(String path) {
  	int pos, oldpos;
  	StringBuffer out = new StringBuffer();
  	oldpos = 0;
  
  	if (path != null) {
    	pos = path.indexOf("%");
    	while (pos > -1) {
      	out.append(path.substring(oldpos,pos));
      	oldpos = pos;
      	pos = path.indexOf("%",pos + 1);
      	if (pos == -1) {
        	pos = path.length();
      	}
      	String dir = path.substring(oldpos + 1, pos);
      	out.append(getSetting("directory."+dir));
      	oldpos = pos+1;
    	  pos = path.indexOf("%",pos + 1);
    	}
    	out.append(path.substring(oldpos,path.length()));
  	}
  	return out.toString();
	}   

	// Methodes non dcrites dans l'ouvraeg  
  	public void setSetting(String cle, String valeur) {
		String index= "";
		int pos;
		pos = cle.indexOf(".");
		if (pos > -1){
			index = cle.substring(0,pos);
		}
		if (index.equals("") || 
			index.equals("include") || 
			index.equals("directory")){
			valeur = base.getProperty(cle);
			return ;
		}else{
			cle = cle.substring(pos + 1);
		}
		
		SettingsSource temp = getSource(index);
		if (temp != null){
			temp.setSetting(cle,valeur);
		}
	}
	
	public Enumeration getPropertyNames(){
		return base.propertyNames();
	}
	
	public Enumeration getPropertyNames(String sub){
		SettingsSource temp = getSource(sub);
		return temp.getPropertyNames();
	}
	

  
  
  
  
  public static void main(String[] args) {
  // test de main
  try {
	  getInstance().load(args[0]);
  } catch (IOException e) {
    System.out.println(e.getMessage());
  }
  
  System.out.println("valeur test: " + getInstance().getSetting("testvaleur"));
  // ou avec la mthode get():
  System.out.println("test 2: " +Settings.get("testvaleur"));

  System.out.print("On peut utiliser le serveur ");
  System.out.print(Settings.get("mail.SMTPHost"));
  System.out.print(" sur le port ");
  System.out.println(Settings.get("mail.SMTPPort"));
  System.out.print("pour envoyer un email  ");
  System.out.println(Settings.get("mail.webmaster"));
  
  System.out.println(Settings.get("db.Mysqltest.URL"));
}

}