package com.wrox.projsp.ch11;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;

public class SettingsServlet extends HttpServlet {
  String fichierConfig;
 
  public void init(ServletConfig conf) throws ServletException {
    super.init(conf);
    fichierConfig= getInitParameter ("fichierConfig");
    try {
      Settings.getInstance().load(fichierConfig);        
    } catch (IOException e) {
      System.out.println(e.getMessage());
    }
  }
  
  public void doGet(HttpServletRequest req, HttpServletResponse res) 
          throws ServletException, IOException {
    res.setContentType("text/html");
    PrintWriter out = res.getWriter();
    out
      .println("<HTML><HEAD><TITLE> SettingsTest </TITLE> </HEAD><BODY> ");
    if ("on".equals(req.getParameter("refresh"))) {
      try {
        Settings.getInstance().load(fichierConfig);
      } catch (IOException e) {
        out.println(e.getMessage());
      } 
    } 

    out.println("<A HREF=" + req.getRequestURI() 
                + "?refresh=on>REFRESH</A><P>");
    out.println("<TABLE>");
    String sub = req.getParameter("sub");
    Enumeration temp;
    if ((sub == null) || ("".equals(sub))) {
      temp = Settings.getInstance().getPropertyNames();
      sub = "";
    } else {
      temp = Settings.getInstance().getPropertyNames(sub);
      sub = sub + ".";
    } 
    while (temp.hasMoreElements()) {
      String name = (String) temp.nextElement();
      String value = Settings.getInstance().get(sub + name);
      out.println("<TR><TD>" + name + "</TD><TD>" + value 
                  + "</TD></TR>");
    } 
    out.println("</TABLE></BODY></HTML>");
  }

}