package com.wrox.projsp.ch12;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;


public class BabyGameServlet extends HttpServlet {
  public void doGet(HttpServletRequest request, 
                    HttpServletResponse response) {
    processRequest(request, response);
  } 

  public void doPost(HttpServletRequest request, 
                     HttpServletResponse response) {
    processRequest(request, response);
  } 

  protected void processRequest(HttpServletRequest request, 
                                HttpServletResponse response) {
    try {
      String guesser = request.getParameter("nom");
      String password = request.getParameter("motdepasse");

      // Authentifier chaque requte
      Authenticator auth = 
        AuthenticatorFactory.create(AuthenticatorFactory.SIMPLE);
      AuthContext authContext = 
        AuthenticatorFactory
          .createContext(AuthenticatorFactory.SIMPLE);
      authContext.addValue("nom", guesser);
      authContext.addValue("motdepasse", password);

      auth.init(authContext);

      if (auth.authenticate()) {
        String dispatchto = request.getParameter("dispatchto");
        String delegateToBean = 
          request.getParameter("delegatetobean");

        // Dlguer au bean de travail
        if (delegateToBean != null) {
          BabyGameWorkerSW worker = new BabyGameWorkerSW();
          worker.load(guesser);
          request.setAttribute("SWworker", worker);
        } 

        // Afin d'utiliser cette servlet dans plusieurs exemples,
        // le nom de la ressource  laquelle est transfre la requte
        //  est pass comme paramtre de requte
        getServletConfig().getServletContext()
          .getRequestDispatcher(dispatchto)
            .forward(request, response);
      } else {
        PrintWriter outy = response.getWriter();
        outy.println("Impossible de valider, essayez  nouveau.");
      } 
    } catch (Exception ex) {
      ex.printStackTrace();
    } 
  } 


}