package com.wrox.projsp.ch12;

import java.io.*;
import java.util.Properties;

public class SimpleStore implements Store
{
    private Properties props;

    public SimpleStore()
    {
    }

    public SimpleStore(Properties p)
    {
        props = p;
    }

    public void store(Properties p) throws StoreException
    {
        props = p;
        store();
    }

    public void store() throws StoreException
    {
        if (props == null)
        {
            throw new StoreException("Probleme.  store est nul.");
        }

        try
        {
            FileOutputStream out = new FileOutputStream((String)props.getProperty("nom"));
            props.save(out, "Jeu du bb -- "+props.get("nom"));
            out.flush();
            out.close();    
        }
        catch (IOException e)
        {
            throw new StoreException("Problme d'criture du fichier: "+e.getMessage());
        }
    }

    public Object load(String id) throws StoreException
    {
        Properties props = new Properties();

        try
        {
            FileInputStream in = new FileInputStream(id);
            props.load(in);
            in.close();
        }
        catch (IOException e)
        {
            throw new StoreException("Problme lors de la lecture du fichier: "+e.getMessage());
        }

        return props;
    }

    public static void main(String[] args) throws Throwable
    {
        Properties p = new Properties();
        p.put("nom", "abc");
        p.put("poisson", "asdfasdfasdfasdfas");
        Store storer = StoreFactory.createStore();
        storer.store(p);
        System.out.println("Chargement russi  --->"+storer.load("abc"));
    }
}
