package com.wrox.projsp.ch13;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

abstract public class BaseHttpServlet extends HttpServlet 
  implements Constantes {

  private static String cNom = "BaseHttpServlet";
  private boolean debugFlag = true;

  abstract public void init() throws ServletException;

  public void doGet(HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException {
    String mNom = new String(cNom + ".doGet(): ");

    System.out.println(mNom + "dbute.");
    System.out.println(mNom + "*** envoie la requte.");
    doPost(request, response);
    System.out.println(mNom + "termine.");
  } // fin doGet.
  abstract public void doPost(HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException;

  abstract public void processRequestType(HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException;

  public void redirectToResource(HttpServletRequest request,
    HttpServletResponse response, String resourceName) 
    throws ServletException, IOException {

      String mNom = new String(cNom + ".redirectToResource(): ");
      System.out.println(mNom + "dbute.");
      System.out.println(mNom + "redirige  jsp=" + resourceName);
      int portServeur = request.getServerPort();
      String systeme = request.getScheme();
      String nomServeur = request.getServerName();
      StringBuffer urlBuffer = new StringBuffer(40);
      urlBuffer.append(systeme + "://" + nomServeur );
      urlBuffer.append(":" + portServeur);
      urlBuffer.append(resourceName);
      if(debugFlag == true) {
        System.out.println("urlBuffer = " + urlBuffer.toString());
        System.out.println(mNom + "systeme = " + systeme);
        System.out.println(mNom + "nomServeur = " + nomServeur);
        System.out.println(mNom + "portServeur = " + portServeur);
        System.out.println(mNom + "urlBuffer = " + urlBuffer.toString());
      }
      String location = response.encodeRedirectURL(urlBuffer.toString());
      response.sendRedirect(location);
      System.out.println(mNom + "termine.");
  } // fin redirectToResource

} // fin classe BaseHttpServlet.