package com.wrox.projsp.ch13;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ServeurProfilUtilisateur extends BaseHttpServlet {
  private static String cNom = "ServeurProfilUtilisateur";

  public static final int REQUETE_EXECUTEE = 11;

  public static final int ERREUR_CORRESPONDANCE_CODE_POSTAL = 20;
  public boolean debugFlag = true;
  private GestionnaireProfil profilManager = null;

  public void init() throws ServletException {
    String mNom = new String(cNom + ".init(): ");
    System.out.println(mNom + "dbute.");
    profilManager = new GestionnaireProfil();
    System.out.println(mNom + "termine.");
  } //end init

  public void doPost (HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException {

    String mNom = new String(cNom + ".doPost(): ");

    System.out.println(mNom + "dbute.");
    processRequestType(request, response);
    System.out.println(mNom + "termine.");

  } //fin doPost
  public void processRequestType(HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException {

    String mNom = new String(cNom + ".processRequestType(): ");
    System.out.println(mNom + "dbute.");

    String reqTypeStr = (String)request.getAttribute("reqType");
    System.out.println(mNom + "reqTypeStr = " + reqTypeStr);

    int requestType = ERREUR;
    // si reqType n'est pas trouv, lancer une exception.
    if(reqTypeStr == null) {
      throw new ServletException(mNom + "reqTypeStr tait null.");
    }
    int rtn = ERREUR;
    requestType = Integer.parseInt(reqTypeStr);
    String target = null;
    switch(requestType) {

      case REQUETE_CREER_PROFIL:
        rtn = soumettreProfilRequete(request, response);
        target = "/projsp/ch13/etapeConnexion2.jsp";
        redirectToResource(request, response, target);
        break;

      case VERIFIER_PROFIL_REPONSE:
        // alreadyCheckedFlag = false
        rtn = verifierProfilReponse(request, response, false);
        System.out.println(mNom + "rtn = " + rtn);

        if(rtn == RESULTATS_VALIDES) {
          target = "/projsp/ch13/afficherCompte.jsp";
        } else {
          target = "/projsp/ch13/traitementAttente.jsp";
        }
        redirectToResource(request, response, target);
        break;

      case VERIFIER_ENCORE_PROFIL_REPONSE:
        rtn = verifierProfilReponse(request, response, true);

        System.out.println(mNom + "rtn = " + rtn);

        if(rtn == RESULTATS_VALIDES) {
          target = "/projsp/ch13/afficherCompte.jsp";
        } else if(rtn == ERREUR || rtn == ECHEC_VERIFICATION_RESULTATS) {
          target = "/projsp/ch13/traitementErreur.jsp";
        } else {
          target = "/projsp/ch13/desole.jsp";
        }
        redirectToResource(request, response, target);
        break;

      default:
        System.out.println(mNom + "cas par dfaut."); 
        throw new ServletException(mNom + "cas par dfaut obtenu.");
    }
    System.out.println(mNom + "termine.");
  } // fin processRequestType

  public int soumettreProfilRequete(HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException {

    String mNom = new String(cNom + ".soumettreProfilRequete(): ");
    System.out.println(mNom + "dbute.");

    StringBuffer erreurMsgBuff = new StringBuffer("le message d'erreur tait: ");
    HttpSession session = request.getSession();
    ConsommateurInfoBean consommateurInfo = 
      (ConsommateurInfoBean)session.getAttribute("consommateurInfo");
    if(consommateurInfo == null) {
      erreurMsgBuff.append("N'a pu obtenir le bean ConsommateurInfo.");
      session.setAttribute("msgErreur", erreurMsgBuff.toString());
      redirectToResource(request, response, "/projsp/ch13/desole.jsp");
    }
    // dbogage
    if(debugFlag == true) {
      System.out.println(mNom + "sessionId = " + session.getId());
      System.out.println(mNom + "NSS = " + consommateurInfo.getSsn());
    }
    profilManager.request(consommateurInfo.getSsn());

    System.out.println(mNom + "termine.");
    return REQUETE_EXECUTEE;

  } // fin soumettreProfilRequete

  public int verifierProfilReponse(HttpServletRequest request,
    HttpServletResponse response, boolean alreadyCheckedFlag) 
    throws ServletException, IOException {

    String mNom = new String(cNom + ".verifierProfilReponse(): ");
    System.out.println(mNom + "dbute.");

    StringBuffer erreurMsgBuff = new StringBuffer("le message d'erreur tait: ");

    HttpSession session = request.getSession();
    ConsommateurInfoBean consommateurInfo = 
      (ConsommateurInfoBean)session.getAttribute(session.getId());

    if(consommateurInfo == null) {
      erreurMsgBuff.append("n'a pu obtenir le bean ConsommateurInfo.");
      session.setAttribute("msgErreur", erreurMsgBuff.toString());
      redirectToResource(request, response, "/projsp/ch13/desole.jsp");
    }

    // obtenir du bean consommateurInfo les valeurs
    String ssn = consommateurInfo.getSsn();
    String motDePasse = consommateurInfo.getMotDePasse();
    String numeroCompte = consommateurInfo.getNumeroCompte();
    String codePostal = consommateurInfo.getCodePostal();
    String email = consommateurInfo.getEmail();
    // dbogage
    if(debugFlag == true) {
      System.out.println(mNom + "sessionId = " + session.getId());
      System.out.println(mNom + "ssn = " +  ssn);
      System.out.println(mNom + "motDePasse = " + motDePasse);
      System.out.println(mNom + "numeroCompte = " + numeroCompte);
      System.out.println(mNom + "codePostal = " + codePostal);
      System.out.println(mNom + "email = " + email);
    }

    int rtn = ERREUR;
    ConsommateurProfil resp = null;
    if(alreadyCheckedFlag == true) {
      resp = profilManager.getConsommateurProfil(ssn);
    } else {
      // Simulation d'un dlai du systme dorsal.
      System.out.println(mNom + "premire requte.");
    }

    if(resp == null) { 
      erreurMsgBuff.append("pas encore de rponse.");
      session.setAttribute("msgErreur", erreurMsgBuff.toString());
      if(alreadyCheckedFlag == false) {
        rtn = TOUJOURS_EN_TRAITEMENT;
        return rtn;
      } else {
        return TIMEOUT;
      }
    } //fin resp == null

    // logique pour comparer ConsommateurProfil renvoy avec les donnes 
    //  reues du client via la page JSP.
    Adresse adresseConsommateur = resp.getAdresseConsommateur();
    String rtnCodePostal = adresseConsommateur.getCodePostal();
    String rtnSSN = resp.getConsommateurSSN();
    String rtnNumeroCompte = resp.getNumeroCompte();
    String rtnEmail = resp.getAdresseEmail();
    String rtnMotDePasse = resp.getMotDePasse();
    System.out.println("rtnCodePostal = " + rtnCodePostal);
    System.out.println("rtnSSN = " + rtnSSN);
    System.out.println("rtnNumeroCompte = " + rtnNumeroCompte);
    System.out.println("rtnEmail = " + rtnEmail);
    System.out.println("rtnMotDePasse = " + rtnMotDePasse);
    boolean flagVerificationCodePostal = false;
    boolean flagVerificationSSN = false;
    boolean flagVerificationCompte = false;
    boolean flagVerificationEmail = false;
    boolean flagVerificationMotDePasse = false;

    if(rtnCodePostal.equals(codePostal)) {
      System.out.println(mNom + "Le code postal correspond  la rponse.");
      flagVerificationCodePostal = true;
    } else {
      erreurMsgBuff.append("Le code postal ne correspond pas " + 
        "  celui obtenu dans ConsommateurProfil.");
      rtn = ECHEC_VERIFICATION_RESULTATS;
    } // fin codePostal

    // viter les comparaisons si la vrification a dj chou
    if(rtn != ECHEC_VERIFICATION_RESULTATS) { 
      if(rtnSSN.equals(ssn)) {
        flagVerificationSSN = true;
        System.out.println(mNom + " Le NSS correspond  la rponse.");
      } else {
        erreurMsgBuff.append("Le NSS ne correspond pas " + 
          "  celui obtenu dans ConsommateurProfil.");
        rtn = ECHEC_VERIFICATION_RESULTATS;
      } // fin ssn
    } // fin ECHEC_VERIFICATION_RESULTATS

    // viter les comparaisons si la vrification a dj chou
    if(rtn != ECHEC_VERIFICATION_RESULTATS) {
      if(rtnNumeroCompte.equals(numeroCompte)) {
        System.out.println(mNom + " Le numro de compte correspond  la rponse.");
        flagVerificationCompte = true;
      } else {
        erreurMsgBuff.append("Le numro de compte ne correspond pas " + 
          " celui obtenu dans ConsommateurProfil.");
        rtn = ECHEC_VERIFICATION_RESULTATS;
      } // fin accountNum
    } // fin ECHEC_VERIFICATION_RESULTATS

    // viter les comparaisons si la vrification a dj chou
    if(rtn != ECHEC_VERIFICATION_RESULTATS) {
      if(rtnEmail.equals(email)) {
        flagVerificationEmail = true;
        System.out.println(mNom + " L'adresse email correspond  la rponse.");
      } else {
        erreurMsgBuff.append("L'adresse email ne correspond pas " + 
          "  celle obtenue dans ConsommateurProfil.");
        rtn = ECHEC_VERIFICATION_RESULTATS;
      } // fin email
    } // fin ECHEC_VERIFICATION_RESULTATS

    // viter les comparaisons si la vrification a dj chou
    if(rtn != ECHEC_VERIFICATION_RESULTATS) {
      if(rtnMotDePasse.equals(motDePasse)) {
        flagVerificationMotDePasse = true;
        System.out.println(mNom + " Le numro de compte correspond  la rponse.");
      } else {
        erreurMsgBuff.append("Le numro de compte ne correspond pas " + 
          "  celui obtenu dans ConsommateurProfil.");
        rtn = ECHEC_VERIFICATION_RESULTATS;
      } // fin password
    } // fin ECHEC_VERIFICATION_RESULTATS

    if(flagVerificationCodePostal && 
        flagVerificationSSN && 
        flagVerificationCompte && 
        flagVerificationEmail && 
        flagVerificationMotDePasse) {
      System.out.println(mNom + "toutes les donnes de vrification correspondent.");
      rtn = RESULTATS_VALIDES;
    } // fin CheckFlags

    if(rtn == RESULTATS_VALIDES) {

      // Pas de problme, on fonctionne par session.
      // ajouter consommateurProfil  session.
      session.setAttribute("consommateurProfil", resp);
      System.out.println(mNom + "consommateurProfil ajout  la session.");

    } else {
      // Pas de problme, on fonctionne par session.
      session.setAttribute("msgErreur", erreurMsgBuff.toString());
    } // fin de if RESULTATS_VALIDES

    System.out.println(mNom + "termine.");
    return rtn;

  } // fin verifierProfilReponse

} //fin classe ServeurProfilUtilisateur 