package com.wrox.projsp.ch13;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ServeurSSNUtilisateur extends BaseHttpServlet {
  private static String libelle = "ServeurSSNUtilisateur";
  private boolean debugFlag = true;

  public void init() throws ServletException {
    String mNom = new String(libelle + ".init(): ");
    System.out.println(mNom + "dbute.");
    System.out.println(mNom + "termine.");
  } //fin init

  public void doPost (HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException {

    String mNom = new String(libelle + ".doPost(): ");

    System.out.println(mNom + "dbute.");
    processRequestType(request, response);
    System.out.println(mNom + "termine.");
  } //fin doPost



  public void processRequestType(HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException {

    String mNom = new String(libelle + ".processRequestType(): ");
    System.out.println(mNom + "dbute.");
    String reqTypeStr = (String)request.getParameter("reqType");
    System.out.println(mNom + "reqTypeStr = " + reqTypeStr);

    int requestType = ERREUR;
    // lance une exception si reqTypeStr pas trouv.
    if(reqTypeStr == null) {
      throw new ServletException(mNom + "reqTypeStr tait null.");
    }
    requestType = Integer.parseInt(reqTypeStr);
    int rtn = ERREUR;
    String target = null;
    switch(requestType) {

      case CREER_LISTE_SSN_VALIDE:
        creerListeSSN(request, response);
        break;

      default:
        System.out.println(mNom + "cas par dfaut.");
        throw new ServletException(mNom + "cas par dfaut obtenu.");
    }
    System.out.println(mNom + "termine.");
  } // fin processRequestType


  public void creerListeSSN(HttpServletRequest request,
    HttpServletResponse response) throws ServletException, IOException {

    String mNom = new String(libelle + ".creerListeSSN(): ");
    System.out.println(mNom + "dbute.");
    ServletContext context = null;

    // construit l'objet crant la liste des numros.
    SSNListe ssnListe = new SSNListe();
    ArrayList ssnArrayList = ssnListe.getSSNListe();

    // place ArrayList dans Servlet Context pour le rendre disponible.
    context = getServletContext();
    context.setAttribute("ListeValideSSN", ssnListe.getSSNListe());
    HttpSession session = request.getSession();
    ConsommateurInfoBean consommateurInfo = 
      (ConsommateurInfoBean)session.getAttribute("consommateurInfo");

    StringBuffer erreurMsgBuff = new StringBuffer("le message d'erreur tait: ");
    if(consommateurInfo == null) {
      erreurMsgBuff.append("n'a pu obtenir le bean UserInfo.");
      session.setAttribute("msgErreur", erreurMsgBuff.toString());
      redirectToResource(request, response, "/projsp/ch13/desole.jsp");
    }


    String ssn = consommateurInfo.getSsn();
    if(ssn == null) {
      System.out.println(mNom + "SSN n'est pas dans le bean consommateurInfo.");
    } else {
      System.out.println(mNom + "valider SSN");
      RequestDispatcher rd = null;
      if(ssnArrayList.contains(ssn) == true) {
        request.setAttribute("reqType", Integer.toString(REQUETE_CREER_PROFIL));
        rd = getServletContext().getRequestDispatcher(
          "/servlet/com.wrox.projsp.ch13.ServeurProfilUtilisateur");
        rd.forward(request, response);

      } else {
        erreurMsgBuff.append("Le numro entr : '" + 
        ssn + "' n'a pas t trouv. Essayez  nouveau si vous " + 
        "avez fait une erreur. Si vous avez entr le bon numro " + 
        "et voulez crer un compte, appelez: 1-800-MFC-AIDE.");
        session.setAttribute("msgErreur", erreurMsgBuff.toString());

        redirectToResource(request, response, 
          "/projsp/ch13/desole.jsp");      }
    }
    System.out.println(mNom + "termine.");
  } // fin creerListeSSN

} //fin classe ServeurSSNUtilisateur 