	
package com.wrox.projsp.ch15;

import java.util.Hashtable;
import java.util.Enumeration;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.event.*;
import javax.naming.ldap.*;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.http.*;

public class doAuth {


  // variables d'utilisateur
  private String ldapHost = "";   // nom du serveur LDAP
  private int ldapPort = 389;     // port d'excution du serveur
  private String searchBase = ""; // base de recherche pour DIT
  //private String managerDN = "uid=mewilcox, ou=People, o=airius.com";  // entre de liaison pour la recherche initiale de DN
  //private String managerPW = "opensesame";  // entre de liaison pour la recherche initiale de pwd
  private String managerDN = "";  // entre de liaison pour la recherche initiale de DN
  private String managerPW = "";  // entre de liaison pour la recherche initiale de pwd
  

  // variables d'application 

  // implmentation initiale du contexte 
  private static String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";

  // les utilisateurs ne peuvent actuellement modifier la porte de la recherche
  private static int scope = 
    SearchControls.SUBTREE_SCOPE;   // porte de la recherche

  private Hashtable userCache = new Hashtable();                
                                    // cache des noms et des DN
  private org.apache.tomcat.core.Context ourCTX = null;

  // utilis pour dbogage/mise en historique
  private Hashtable userRoles = new Hashtable();

  // suivi des rles d'un utilisateur
  private Hashtable env = null;   // enregistre l'information de configuration LDAP 

  /** constructeur par dfaut */
  public void doAuth()
  {
  }


  /** dfinir le nom d'hte du serveur LDAP */
  public void setHost(String host) {
    ldapHost = host;
  }

  /** obtenir le nom d'hte du serveur LDAP */
  public String getHost() {
    return ldapHost;
  } 

  /** dfinir le port du serveur LDAP */
  public void setPort(int port) {
    ldapPort = port;
  }

  /** obtenir le port du serveur LDAP */
  public int getPort() {
    return ldapPort;
  }

  /** dfinir la base de recherche LDAP */
  public void setSearchbase(String base) {
    searchBase = base;
  }
  
  /** obtenir la base de recherche LDAP */
  public String getSearchbase() {
    return searchBase;
  }

  /** dfinir le DN 'manager' de connexion*/
  public void setManagerDN(String dn) {
    managerDN = dn;
  }

  /** obtenir le DN 'manager' de connexion */
  public String getManagerDN() {
    return managerDN;
  }

  /** dfinir le mot de passe de connexion 'manager' */
  public void setManagerPW (String password) {
    managerPW = password;
  }

  /** obtenir le mot de passe de connexion 'manager' */
  public String getManagerPW() {
    return managerPW;
  }


/** excute une simple authentification LDAP */
public boolean LDAPauthenticate (String utilisateur, String motDePasse) {
  if ( (motDePasse == null) || (motDePasse.equals("")) ){
    return false;
  }

  try {
  
      Hashtable env = new Hashtable();
      //Specify which class to use for our JNDI provider
      env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);
      //specify which host and port
      StringBuffer jndiHost = new StringBuffer (); //hold JNDI host url
      jndiHost.append("ldap://");
      jndiHost.append(ldapHost);
      jndiHost.append(":");
      jndiHost.append(ldapPort);
      env.put(Context.PROVIDER_URL,jndiHost.toString()); 
      //Security Information
      env.put(Context.SECURITY_AUTHENTICATION,"simple");
	  System.out.println("Avant configuration securite");
      env.put(Context.SECURITY_PRINCIPAL,managerDN);
      env.put(Context.SECURITY_CREDENTIALS,managerPW);
  
    //obtenir une rfrence  un contexte de rpertoire
    DirContext ctx = new InitialDirContext(env);
	System.out.println("Apres recuperation contexte");
    /*
    rcupre l'entre de l'utilisateur
    assume que son id est stock dans l'attribut uid 
    Les attributs renvoys sont limits  son uid 
    parce que rien d'autre n'est vraiment ncessaire du
    serveur LDAP et afin de limiter le traitement demand.
   */
    StringBuffer filterBuffer = new StringBuffer ("uid=");
    filterBuffer.append(utilisateur);

    String[] attrIDs = {"uid"};
    SearchControls ctls = new SearchControls();
    ctls.setReturningAttributes(attrIDs);       
    ctls.setSearchScope(scope); 

    // Recherche d'objets avec ces attributs
    NamingEnumeration results = ctx.search(searchBase,
                                           filterBuffer.toString(),ctls);

    StringBuffer dnBuffer = new StringBuffer (); //contient les rsultats
    
    while (results != null && results.hasMore()) {
      SearchResult sr = (SearchResult) results.next();
      dnBuffer.append(sr.getName());
      dnBuffer.append(",");
      dnBuffer.append(searchBase);

      userCache.put(utilisateur,dnBuffer.toString());

      //essayer maintenant de se relier  nouveau au serveur comme l'utilisateur
      ctx.removeFromEnvironment(javax.naming.Context.SECURITY_PRINCIPAL);
      ctx.removeFromEnvironment(javax.naming.Context.SECURITY_CREDENTIALS);
      ctx.addToEnvironment(javax.naming.Context.SECURITY_PRINCIPAL,
                           dnBuffer.toString());
      ctx.addToEnvironment(javax.naming.Context.SECURITY_CREDENTIALS,
                           motDePasse);

      //essayer une opration pour vrifier si l'authentification
      //est toujours valide
      // Dfinir les contrles de recherche
      ctls = new SearchControls();
      ctls.setReturningAttributes(new String[0]);      
      ctls.setSearchScope(SearchControls.OBJECT_SCOPE);// recherche de l'objet seul
      //comparaison JNDI, opration intensive
     //test de la russite ou de l'chec de la connexion
     NamingEnumeration authResults = ctx.search(dnBuffer.toString(),
                                                "(uid=mark)",ctls);

     return true;
   }

  } catch (NamingException ne) {
    ourCTX.log( "Erreur de nommage : " + ne.toString());
    return false;
  }

  return false;
}

/** vrifier si l'utilisateur est dans le rle appropri, ici un groupe LDAP. C'est trs simple
maintenant. La chane doit correspondre  l'attribut CN d'un groupe. Sont traits les membres de groupOfMembers et groupOfUniquemembers. Les groupes hrits ou dynamiques ne le sont pas. */
private boolean LDAPuserInRole (String utilisateur, String nomDeGroupe) {

  String utilisateurDN = (String) userCache.get(utilisateur);
  if (utilisateurDN == null) return false;

  try {
    //Obtenir une rfrence  un contexte de rpertoire
    DirContext ctx = new InitialDirContext(env);

    //rechercher  la fois le groupe et le membre
    StringBuffer filterBuffer = new StringBuffer ("(&(cn=");
    filterBuffer.append(nomDeGroupe);
    filterBuffer.append(")(|(uniquemember=");
    filterBuffer.append(utilisateurDN);
    filterBuffer.append(")(membre=");
    filterBuffer.append(utilisateurDN);
    filterBuffer.append(")))");

    String[] attrIDs = {"uniquemember"};
    SearchControls ctls = new SearchControls();
    ctls.setReturningAttributes(attrIDs);       
    ctls.setSearchScope(scope); 

    // Rechercher des objets avec les attributs correspondants
    NamingEnumeration results = ctx.search(searchBase,
                                           filterBuffer.toString(),ctls);

    StringBuffer dnBuffer = new StringBuffer (); // contient les rsultats

    if (results != null && results.hasMore()) {
      return true;
    }

  } catch (NamingException ne) {
    ourCTX.log( "Erreur de nommage dans inRole: " + ne.toString());
  }

  return false;
}

  // fonction de test
  public static void main (String args[]) {
	doAuth la = new doAuth();
    la.setHost("ntwm1167");
    la.setPort(389);
    la.setSearchbase("ou=people, o=airius.com");
    System.out.println("l'authentification est " +
                       la.LDAPauthenticate("mewilcox","opensesame") );
  }
}
	
	
	