package com.wrox.projsp.ch15;

import java.util.Hashtable;
import java.util.Enumeration;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.event.*;
import javax.naming.ldap.*;

import org.apache.tomcat.core.*;
import org.apache.tomcat.util.*;
import org.apache.tomcat.util.xml.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.http.*;
import org.xml.sax.*;

public class ldapAuthCheck extends org.apache.tomcat.request.SecurityCheck {

  // variables d'utilisateur
  private String ldapHost = "";   // nom du serveur LDAP
  private int ldapPort = 389;     // port d'excution du serveur
  private String searchBase = ""; // base de recherche pour DIT
  private String managerDN = "";  // entre de liaison pour la recherche initiale de DN
  private String managerPW = "";  // entre de liaison pour la recherche initiale de pwd

  // variables d'application 

  // implmentation initiale du contexte 
  private static String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";

  // les utilisateurs ne peuvent actuellement modifier la porte de la recherche
  private static int scope = 
    SearchControls.SUBTREE_SCOPE;   // porte de la recherche

  private Hashtable userCache = new Hashtable();                
                                    // cache des noms et des DN
  private org.apache.tomcat.core.Context ourCTX = null;

  // utilis pour dbogage/mise en historique
  private Hashtable userRoles = new Hashtable();

  // suivi des rles d'un utilisateur
  private Hashtable env = null;   // enregistre l'information de configuration LDAP 

  /** constructeur par dfaut */
  public void ldapAuthCheck() {}

  public void contextInit(org.apache.tomcat.core.Context ctx) 
          throws TomcatException {
    ourCTX = ctx;
    super.contextInit(ctx);
  }

  /** dfinir le nom d'hte du serveur LDAP */
  public void setHost(String host) {
    ldapHost = host;
  }

  /** obtenir le nom d'hte du serveur LDAP */
  public String getHost() {
    return ldapHost;
  } 

  /** dfinir le port du serveur LDAP */
  public void setPort(int port) {
    ldapPort = port;
  }

  /** obtenir le port du serveur LDAP */
  public int getPort() {
    return ldapPort;
  }

  /** dfinir la base de recherche LDAP */
  public void setSearchbase(String base) {
    searchBase = base;
  }
  
  /** obtenir la base de recherche LDAP */
  public String getSearchbase() {
    return searchBase;
  }

  /** dfinir le DN 'manager' de connexion*/
  public void setManagerDN(String dn) {
    managerDN = dn;
  }

  /** obtenir le DN 'manager' de connexion */
  public String getManagerDN() {
    return managerDN;
  }

  /** dfinir le mot de passe de connexion 'manager' */
  public void setManagerPW (String password) {
    managerPW = password;
  }

  /** obtenir le mot de passe de connexion 'manager' */
  public String getManagerPW() {
    return managerPW;
  }

  /** hrit de SecurityCheck*/
  protected boolean checkPassword (String utilisateur, String motDePasse) {
    ourCTX.log("checkPassword vrai/faux est un " 
               + LDAPauthenticate(utilisateur, motDePasse));
    return LDAPauthenticate(utilisateur, motDePasse);
  }


protected boolean userInRole(String utilisateur, String role) {
  ourCTX.log("le rle est " + LDAPuserInRole(utilisateur,role));
  return LDAPuserInRole(utilisateur,role);
}


//utilis simplement pour remplir l'environnement
public int authenticate(Request req, Response reponse) {
	System.out.println("Debut de authenticate");
  org.apache.tomcat.core.Context ctx=req.getContext();
  env = getEnv(ctx);
  return super.authenticate(req,reponse);
}

/** dfinir la configuration LDAP */
private Hashtable getEnv(org.apache.tomcat.core.Context ctx) {
  //obtenir les donnes du fichier XML 
  try {
    ldapHost = ctx.getInitParameter("com.wrox.projsp.ch15.ldapAuthCheck.ldaphost");
	System.out.println("ldapHost "+ldapHost);
    Integer tempPort = new Integer(ctx.getInitParameter
                                   ("com.wrox.projsp.ch15.ldapAuthCheck.ldapport"));
	ldapPort = tempPort.intValue();
	System.out.println("port "+ldapPort);
    searchBase = ctx.getInitParameter
                   ("com.wrox.projsp.ch15.ldapAuthCheck.searchbase");
    managerDN = ctx.getInitParameter
                   ("com.wrox.projsp.ch15.ldapAuthCheck.managerdn");
    managerPW = ctx.getInitParameter
                   ("com.wrox.projsp.ch15.ldapAuthCheck.managerpw");
    // si null, dfinir une connexion anonyme
    if ((managerDN == null) || (managerPW == null)) {
      managerDN = "";
      managerPW = "";
    }

	System.out.println("Manager dn "+managerDN+"ManagerPW "+managerPW);
    Hashtable env = new Hashtable();
    //Dterminer quelle classe utiliser pour le fournisseur JNDI 
    env.put(javax.naming.Context.INITIAL_CONTEXT_FACTORY, INITCTX);

    //spcifier l'hte et le port
    StringBuffer jndiHost = new StringBuffer (); //contient l'url de l'hte JNDI
    jndiHost.append("ldap://");
    jndiHost.append(ldapHost);
    jndiHost.append(":");
    jndiHost.append(ldapPort);
    env.put(javax.naming.Context.PROVIDER_URL,jndiHost.toString()); 

    //Informations de scurit
    env.put(javax.naming.Context.SECURITY_AUTHENTICATION,"simple");
    env.put(javax.naming.Context.SECURITY_PRINCIPAL,managerDN);
    env.put(javax.naming.Context.SECURITY_CREDENTIALS,managerPW);
    return env;
  } catch (NullPointerException ne) {
    ctx.log("getEnv a rencontr une exception de pointeur null "+ne.toString());
  } catch (NumberFormatException nfe) {
    ctx.log("getEnv a rencontr une exception de format de nombre "+nfe.toString());
  }
  return null;
}

/** excute une simple authentification LDAP */
private boolean LDAPauthenticate (String utilisateur, String motDePasse) {
  if ((env == null) || (motDePasse == null) || (motDePasse.equals(""))) {
    return false;
  }

	System.out.println("On va chercher une reference");
  try {
    //obtenir une rfrence  un contexte de rpertoire
    DirContext ctx = new InitialDirContext(env);

    /*
    rcupre l'entre de l'utilisateur
    assume que son id est stock dans l'attribut uid 
    Les attributs renvoys sont limits  son uid 
    parce que rien d'autre n'est vraiment ncessaire du
    serveur LDAP et afin de limiter le traitement demand.
   */
    StringBuffer filterBuffer = new StringBuffer ("uid=");
    filterBuffer.append(utilisateur);

    String[] attrIDs = {"uid"};
    SearchControls ctls = new SearchControls();
    ctls.setReturningAttributes(attrIDs);       
    ctls.setSearchScope(scope); 

	System.out.println("On va rechercher les objets");
    // Recherche d'objets avec ces attributs
    NamingEnumeration results = ctx.search(searchBase,
                                           filterBuffer.toString(),ctls);

    StringBuffer dnBuffer = new StringBuffer (); //contient les rsultats
    
    while (results != null && results.hasMore()) {
      SearchResult sr = (SearchResult) results.next();
      dnBuffer.append(sr.getName());
      dnBuffer.append(",");
      dnBuffer.append(searchBase);
		System.out.println("on memorise "+dnBuffer.toString());
      userCache.put(utilisateur,dnBuffer.toString());

      //essayer maintenant de se relier  nouveau au serveur comme l'utilisateur
      ctx.removeFromEnvironment(javax.naming.Context.SECURITY_PRINCIPAL);
      ctx.removeFromEnvironment(javax.naming.Context.SECURITY_CREDENTIALS);
      ctx.addToEnvironment(javax.naming.Context.SECURITY_PRINCIPAL,
                           dnBuffer.toString());
      ctx.addToEnvironment(javax.naming.Context.SECURITY_CREDENTIALS,
                           motDePasse);

      //essayer une opration pour vrifier si l'authentification
      //est toujours valide
      // Dfinir les contrles de recherche
      ctls = new SearchControls();
      ctls.setReturningAttributes(new String[0]);      
      ctls.setSearchScope(SearchControls.OBJECT_SCOPE);// recherche de l'objet seul
      //comparaison JNDI, opration intensive
     //test de la russite ou de l'chec de la connexion
     NamingEnumeration authResults = ctx.search(dnBuffer.toString(),
                                                "(uid=mark)",ctls);

     return true;
   }

  } catch (NamingException ne) {
    ourCTX.log( "Erreur de nommage : " + ne.toString());
    return false;
  }

  return false;
}

/** vrifier si l'utilisateur est dans le rle appropri, ici un groupe LDAP. C'est trs simple
maintenant. La chane doit correspondre  l'attribut CN d'un groupe. Sont traits les membres de groupOfMembers et groupOfUniquemembers. Les groupes hrits ou dynamiques ne le sont pas. */
private boolean LDAPuserInRole (String utilisateur, String nomDeGroupe) {

  String utilisateurDN = (String) userCache.get(utilisateur);
  if (utilisateurDN == null) return false;

  try {
    //Obtenir une rfrence  un contexte de rpertoire
    DirContext ctx = new InitialDirContext(env);

    //rechercher  la fois le groupe et le membre
    StringBuffer filterBuffer = new StringBuffer ("(&(cn=");
    filterBuffer.append(nomDeGroupe);
    filterBuffer.append(")(|(uniquemember=");
    filterBuffer.append(utilisateurDN);
    filterBuffer.append(")(membre=");
    filterBuffer.append(utilisateurDN);
    filterBuffer.append(")))");

    String[] attrIDs = {"uniquemember"};
    SearchControls ctls = new SearchControls();
    ctls.setReturningAttributes(attrIDs);       
    ctls.setSearchScope(scope); 

    // Rechercher des objets avec les attributs correspondants
    NamingEnumeration results = ctx.search(searchBase,
                                           filterBuffer.toString(),ctls);

    StringBuffer dnBuffer = new StringBuffer (); // contient les rsultats

    if (results != null && results.hasMore()) {
      return true;
    }

  } catch (NamingException ne) {
    ourCTX.log( "Erreur de nommage dans inRole: " + ne.toString());
  }

  return false;
}

  // fonction de test
  public static void main (String args[]) {
    ldapAuthCheck la = new ldapAuthCheck();
    la.setHost("ldap:///ntwm1167.sernit.francetelecom.fr");
    la.setPort(389);
    la.setSearchbase("ou=People, o=airius.com");
    System.out.println( "authentication is " + la.LDAPauthenticate("mewilcox","opensesame") );


                       ldapAuthCheck la2 = new ldapAuthCheck();
                       la2.setHost("ldap:///ntwm1167.sernit.francetelecom.fr");
                       la2.setPort(389);
                       la2.setSearchbase("ou=admin, o=airius.com");
                       System.out.println( "authentication 2is " + la.LDAPauthenticate("FEstival","estival") );
					   
  }
}
