	
package com.wrox.projsp.ch15;

import java.util.Hashtable;
import java.util.Enumeration;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.event.*;
import javax.naming.ldap.*;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.http.*;

public class updateUtilisateur {


  // variables d'utilisateur
  private String ldapHost = "";   // nom du serveur LDAP
  private int ldapPort = 389;     // port d'excution du serveur
  private String searchBase = ""; // base de recherche pour DIT
  private String managerDN = "";  // entre de liaison pour la recherche initiale de DN
  private String managerPW = "";  // entre de liaison pour la recherche initiale de pwd

  // variables d'application 

  // implmentation initiale du contexte 
  private static String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";

  // les utilisateurs ne peuvent actuellement modifier la porte de la recherche
  private static int scope = 
    SearchControls.SUBTREE_SCOPE;   // porte de la recherche

  private Hashtable userCache = new Hashtable();                
                                    // cache des noms et des DN
  private org.apache.tomcat.core.Context ourCTX = null;

  // utilis pour dbogage/mise en historique
  private Hashtable userRoles = new Hashtable();

  // suivi des rles d'un utilisateur
  private Hashtable env = null;   // enregistre l'information de configuration LDAP 

  /** constructeur par dfaut */
  public void doAuth()
  {
  }


  /** dfinir le nom d'hte du serveur LDAP */
  public void setHost(String host) {
    ldapHost = host;
  }

  /** obtenir le nom d'hte du serveur LDAP */
  public String getHost() {
    return ldapHost;
  } 

  /** dfinir le port du serveur LDAP */
  public void setPort(int port) {
    ldapPort = port;
  }

  /** obtenir le port du serveur LDAP */
  public int getPort() {
    return ldapPort;
  }

  /** dfinir la base de recherche LDAP */
  public void setSearchbase(String base) {
    searchBase = base;
  }
  
  /** obtenir la base de recherche LDAP */
  public String getSearchbase() {
    return searchBase;
  }

  /** dfinir le DN 'manager' de connexion*/
  public void setManagerDN(String dn) {
    managerDN = dn;
  }

  /** obtenir le DN 'manager' de connexion */
  public String getManagerDN() {
    return managerDN;
  }

  /** dfinir le mot de passe de connexion 'manager' */
  public void setManagerPW (String password) {
    managerPW = password;
  }

  /** obtenir le mot de passe de connexion 'manager' */
  public String getManagerPW() {
    return managerPW;
  }


/** renvoie un objet PortailPersonne contenant des donnes du
      serveur LDAP */
  public void updateUtilisateur(String nomUtilisateur, String url, boolean replace) {
    try {
      Hashtable env = new Hashtable();

      // Indiquer quelle classe utiliser pour le fournisseur JNDI 
      env.put(javax.naming.Context.INITIAL_CONTEXT_FACTORY, INITCTX);

      // indiquer l'hte et le port
      StringBuffer jndiHost = new StringBuffer();   // contient l'url de l'hte JNDI
      jndiHost.append("ldap://");
      jndiHost.append(ldapHost);
      jndiHost.append(":");
      jndiHost.append(ldapPort);
      env.put(javax.naming.Context.PROVIDER_URL, jndiHost.toString());

      // Informations de scurit
      env.put(javax.naming.Context.SECURITY_AUTHENTICATION, "simple");
      env.put(javax.naming.Context.SECURITY_PRINCIPAL, managerDN);
      env.put(javax.naming.Context.SECURITY_CREDENTIALS, managerPW);
      // Obtenir une rfrence  un contexte de rpertoire
      DirContext ctx = new InitialDirContext(env);
      StringBuffer dnBuffer = new StringBuffer();
      dnBuffer.append("uid=");
      dnBuffer.append(nomUtilisateur);
      dnBuffer.append(",");
      dnBuffer.append(searchBase);

     ModificationItem[] mods = new ModificationItem[1];
	if ( replace == true)
	{
  		Attribute mod0 = new BasicAttribute("labeleduri", url);

  		//si une valeur est donne, elle seule est supprime
  		mods[0] = new ModificationItem(DirContext.REMOVE_ATTRIBUTE, mod0);
	}

	else
	{
  		Attribute mod0 = new BasicAttribute("labeleduri", url);
  		mods[0] = new ModificationItem(DirContext.ADD_ATTRIBUTE, mod0);
	}


	/* faire la modification */
	ctx.modifyAttributes(dnBuffer.toString(), mods);


    } catch (NamingException ne) {
      System.err.println(ne.toString());
    } 
  }


}
	
	
	